% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/persons.get_all.R
\name{persons.get_all}
\alias{persons.get_all}
\title{Get all persons}
\usage{
persons.get_all(user_id = NULL, filter_id = NULL, first_char = NULL,
  start = NULL, limit = NULL, sort = NULL, api_token = NULL,
  company_domain = "api")
}
\arguments{
\item{user_id}{If supplied, only persons owned by the given user will be returned.}

\item{filter_id}{ID of the filter to use}

\item{first_char}{If supplied, only persons whose name starts with the specified letter will be returned (case insensitive).}

\item{start}{Pagination start}

\item{limit}{Items shown per page}

\item{sort}{Field names and sorting mode separated by a comma (field_name_1 ASC, field_name_2 DESC). Only first-level field keys are supported (no nested keys).}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}
}
\value{
return an object List()
}
\description{
Function to Get all persons from pipedrive.
}
\examples{
\donttest{
persons.get_all(api_token='token',company_domain='exp')
}
}
