% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipelines.get.movement_statistics.R
\name{pipelines.get.movement_statistics}
\alias{pipelines.get.movement_statistics}
\title{Get deals movements in pipeline}
\usage{
pipelines.get.movement_statistics(id, start_date, end_date,
  user_id = NULL, api_token = NULL, company_domain = "api")
}
\arguments{
\item{id}{ID of the pipeline.}

\item{start_date}{Start of the period. Date in format of YYYY-MM-DD.}

\item{end_date}{End of the period. Date in format of YYYY-MM-DD.}

\item{user_id}{ID of the user who's pipeline statistics to fetch. If omitted, the authorized user will be used.}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}
}
\value{
return an object List()
}
\description{
Function to Get deals movements in pipeline from pipedrive.
}
\examples{
\donttest{
pipelines.get.movement_statistics(id='e.g.',start_date='e.g.',end_date='e.g.')
}
}
