% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchresults.get.R
\name{searchresults.get}
\alias{searchresults.get}
\title{Perform a search}
\usage{
searchresults.get(term, item_type = NULL, start = NULL, limit = NULL,
  exact_match = NULL, api_token = NULL, company_domain = "api")
}
\arguments{
\item{term}{Search term to look for, minimum 2 characters.}

\item{item_type}{Search for items of exact type. If omitted, all types of items are searched. This field has the following domains: (deal; person; organization; product; file)}

\item{start}{Pagination start}

\item{limit}{Items shown per page}

\item{exact_match}{When enabled, only full exact matches against the given term are returned. The minimum 2 character limit for the term is discarded when exact_match is enabled. It will only work if search term is 30 characters or less. This field has the following domains: (0; 1)}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}
}
\value{
return an object List()
}
\description{
Function to Perform a search from pipedrive.
}
\examples{
\donttest{
searchresults.get(term='e.g.',api_token='token',company_domain='exp')
}
}
