% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpb.R
\name{rpb}
\alias{rpb}
\title{Estimation of latent class mixed multinomial probit models via Gibbs sampling}
\usage{
rpb(
  model = NULL,
  data = NULL,
  parm = NULL,
  lcus = NULL,
  init = NULL,
  prior = NULL,
  mcmc = NULL,
  norm = NULL,
  out = NULL
)
}
\arguments{
\item{model}{A list of model information.}

\item{data}{A list of data information.}

\item{parm}{A list of true parameter values.}

\item{lcus}{A list of latent class updating scheme parameters.}

\item{init}{A list of initial values for the Gibbs sampler.}

\item{prior}{A list of prior parameters.}

\item{mcmc}{A list of Markov chain Monte Carlo parameters.}

\item{norm}{A list of normalization information.}

\item{out}{A list of output settings.}
}
\value{
No return value by default.
Function returns a list of estimates if \code{out[["return"]] = TRUE}.
Results saved in folder "\code{out[["rdir"]]/out[["id"]]}".
}
\description{
Function that performs Gibbs sampling and returns model results.
}
\details{
The model specifications are ordered in named lists.
You can either specify none, all, or only selected parameters.
Unspecified parameters are set to default values.
See the README file for details.
}
\examples{
\dontrun{
### fit a multinomial probit model to simulated data with default parameters
### computation time: < 1 min
rpb()
}
}
