% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gibbs_sampling}
\alias{gibbs_sampling}
\title{Gibbs sampler.}
\usage{
gibbs_sampling(
  R,
  B,
  print_progress,
  N,
  J,
  P_f,
  P_r,
  latent_classes,
  sufficient_statistics,
  prior,
  init
)
}
\arguments{
\item{R}{The number of iterations of the Gibbs sampler.}

\item{B}{The length of the burn-in period, i.e. a non-negative number of samples to
be discarded.}

\item{print_progress}{A boolean, determining whether to print the Gibbs sampler progress and the
estimated remaining computation time.}

\item{N}{The number (greater or equal 1) of decision makers.}

\item{J}{The number (greater or equal 2) of choice alternatives.}

\item{P_f}{The number of covariates connected to a fixed coefficient (can be 0).}

\item{P_r}{The number of covariates connected to a random coefficient (can be 0).}

\item{latent_classes}{Either \code{NULL} or a list of parameters specifying the number and the
latent classes:
\itemize{
\item \code{C}:
The number (greater or equal 1) of latent classes, which is set to 1 per
default and is ignored if \code{P_r = 0}.
If \code{update = TRUE}, \code{C} equals the initial number of classes.
\item \code{update}:
A boolean, determining whether to update \code{C}.
Ignored if \code{P_r = 0}.
If \code{update = FALSE}, all of the following elements are ignored.
\item \code{Cmax}:
The maximum number of latent classes.
\item \code{buffer}:
The updating buffer (number of iterations to wait before the next update).
\item \code{epsmin}:
The threshold weight for removing latent classes (between 0 and 1).
\item \code{epsmax}:
The threshold weight for splitting latent classes (between 0 and 1).
\item \code{distmin}:
The threshold difference in means for joining latent classes
(non-negative).
}}

\item{sufficient_statistics}{The output of \code{\link{compute_sufficient_statistics}}.}

\item{prior}{A named list of parameters for the prior distributions of the normalized
parameters:
\itemize{
\item \code{eta}:
The mean vector of length \code{P_f} of the normal prior for
\code{alpha}.
\item \code{Psi}:
The covariance matrix of dimension \code{P_f} x \code{P_f} of the
normal prior for \code{alpha}.
\item \code{delta}:
The concentration parameter of length 1 of the Dirichlet prior for
\code{s}.
\item \code{xi}:
The mean vector of length \code{P_r} of the normal prior for each
\code{b_c}.
\item \code{D}:
The covariance matrix of dimension \code{P_r} x \code{P_r} of the
normal prior for each \code{b_c}.
\item \code{nu}:
The degrees of freedom (a natural number greater than \code{P_r}) of
the Inverse Wishart prior for each \code{Omega_c}.
\item \code{Theta}:
The scale matrix of dimension \code{P_r} x \code{P_r} of the
Inverse Wishart prior for each \code{Omega_c}.
\item \code{kappa}:
The degrees of freedom (a natural number greater than \code{J-1}) of
the Inverse Wishart prior for \code{Sigma}.
\item \code{E}:
The scale matrix of dimension \code{J-1} x \code{J-1} of the
Inverse Wishart prior for \code{Sigma}.
}}

\item{init}{The output of \code{\link{set_initial_gibbs_values}}.}
}
\value{
A list of Gibbs samples for \code{Sigma}, \code{alpha} (if \code{P_f>0})
and \code{s}, \code{b}, \code{Omega} and a vector of classifications
(if \code{P_r>0}).
}
\description{
This function performs Gibbs sampling for the RprobitB package.
}
\keyword{internal}
