% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overview_effects.R
\name{overview_effects}
\alias{overview_effects}
\title{Overview of effects.}
\usage{
overview_effects(form, re = NULL, alternatives)
}
\arguments{
\item{form}{A formula object that is used to specify the probit model.
The structure is \code{choice ~ A | B | C}, where
\itemize{
\item \code{A} are names of alternative and choice situation specific
covariates with a generic coefficient,
\item \code{B} are names of choice situation specific covariates with
alternative specific coefficients,
\item and \code{C} are names of alternative and choice situation specific
covariates with alternative specific coefficients.
}
Separate multiple covariates of one type by a \code{+} sign.
By default, alternative specific constants (ASCs) are added to the model
(for all except for the last alternative).
They can be removed by adding \code{+0} in the second spot.
See the vignette \code{vignette("data_management", package = "RprobitB")}
for more details.}

\item{re}{A character (vector) of covariates of \code{form} with random effects.
If \code{re = NULL} (the default), there are no random effects.
To have random effects for the alternative specific constants, include
\code{"ASC"} in \code{re}.}

\item{alternatives}{A character vector with the names of the choice alternatives.
If not specified, the choice set is defined by the observed choices.}
}
\value{
A data frame with the coefficient names and booleans indicating whether
they are connected to random effects.
}
\description{
This function gives an overview of the linear coefficients and whether they
are connected to random effects.
}
