% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_evaluation.R
\name{parameter_labels}
\alias{parameter_labels}
\title{Create parameters labels}
\usage{
parameter_labels(
  P_f,
  P_r,
  J,
  C,
  cov_sym,
  ordered = FALSE,
  keep_par = c("s", "alpha", "b", "Omega", "Sigma", "d"),
  drop_par = NULL
)
}
\arguments{
\item{P_f}{The number of covariates connected to a fixed coefficient (can be 0).}

\item{P_r}{The number of covariates connected to a random coefficient (can be 0).}

\item{J}{The number (greater or equal 2) of choice alternatives.}

\item{cov_sym}{Set to \code{TRUE} for labels of symmetric covariance elements.}

\item{ordered}{A boolean, \code{FALSE} per default. If \code{TRUE}, the choice set
\code{alternatives} is assumed to be ordered from worst to best.}

\item{keep_par}{A vector of parameter names which are kept.}

\item{drop_par}{A vector of parameter names which get dropped.}
}
\value{
A list of labels for the selected model parameters.
}
\description{
This function creates model parameter labels.
}
\examples{
RprobitB:::parameter_labels(P_f = 1, P_r = 2, J = 3, C = 2, cov_sym = TRUE)

}
\keyword{internal}
