% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rpvt-package.R
\name{pvt_water}
\alias{pvt_water}
\title{Create a matrix of PVT properties for reservoir water samples}
\usage{
pvt_water(
  input_unit = "Field",
  output_unit = "Filed",
  fluid = "water",
  pvt_model = "Spivey",
  visc_model = "Spivey",
  t = 220,
  p = 6000,
  salinity = 10,
  gas_saturated = "yes",
  warning = "yes"
)
}
\arguments{
\item{input_unit}{input unit system for parameters, a character string either 'SI' or 'Field'.}

\item{output_unit}{output unit system for properties, a character string}

\item{fluid}{fluid type, the character string 'water'}

\item{pvt_model}{PVT model, a character string. 'Spivey', 'Meehan', and 'McCain' models are currently available}

\item{visc_model}{viscosity model, a character string. 'Spivey', 'Meehan', and 'McCain' models are currently available}

\item{t}{temperature, a numeric value either in 'C' or 'F' depending on the 'input_unit'}

\item{p}{pressure, a numeric value either in 'kPag' or 'Psig' depending on the 'input_unit'}

\item{salinity}{water salinity in weight percent TDS}

\item{gas_saturated}{a charater string either 'yes' or 'no'}

\item{warning}{a charater string either 'yes' or 'no'}
}
\description{
The pvt_water() generates a table of water PVT properties at reservoir temperature and pressures from the atmospheric condition up to the initial reservoir pressure. The estimated water properties are solution gas-water ratio, formation volume factor, density, compressibility, and viscosity.
}
\examples{
pvt_water_results_1 <- pvt_water(input_unit = "Field", output_unit = "Field",
fluid = "water", pvt_model = "McCain", visc_model = "McCain",
t = 300, p = 5000, salinity = 10, gas_saturated = "yes", warning = "no")

head(pvt_water_results_1)

pvt_water_results_2 <- pvt_water(input_unit = "SI", output_unit = "SI",
fluid = "water", pvt_model = "Spivey", visc_model = "Spivey",
t = 100, p = 15000, salinity = 0.0, gas_saturated = "no", warning = "no")

head(pvt_water_results_2)

}
\references{
\insertRef{Meehan1980a}{Rpvt}

\insertRef{Meehan1980b}{Rpvt}

\insertRef{McCainJr.1991}{Rpvt}

\insertRef{Spivey2004}{Rpvt}

\insertRef{McCainJr.2011}{Rpvt}
}
