% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confintmlx.R
\name{confintmlx}
\alias{confintmlx}
\title{Confidence intervals for population parameters}
\usage{
confintmlx(project, parameters = "all", method = "fim", level = 0.9,
  linearization = TRUE, nboot = 100, settings = NULL)
}
\arguments{
\item{project}{a Monolix project}

\item{parameters}{list of parameters for which confidence intervals are computed (default="all")}

\item{method}{method c({"fim"}, "proflike", "bootstrap")}

\item{level}{confidence level, a real number between 0 and 1 (default=0.90)}

\item{linearization}{{TRUE}/FALSE  whether the calculation of the standard errors 
or the profile likelihood  is based on a linearization of the model (default=TRUE)}

\item{nboot}{number of bootstrat replicates (default=100, used when method="bootstrap")}

\item{settings}{a list of settings for the profile likelihood method:
\itemize{
\item \code{max.iter} maximum number of iterations to find the solution (default=10)
\item \code{tol.LL} absolute tolerance for -2LL  (default=0.001)
\item \code{tol.param} relative tolerance for the parameter (default=0.01)
\item \code{print} {TRUE}/FALSE display the results (default=TRUE)
}}
}
\value{
a list with the computed confidence intervals, the method used and the level.
}
\description{
Compute confidence intervals for the population parameters estimated by Monolix.
}
\details{
The method used for computing the confidence intervals can be either based on the 
standard errors derived from an estimation of the Fisher Information Matrix ("fim"),
on the profile likelihood ("proflike") or on nonparametric bootstrap estimate ("bootstrap").
\code{method="fim"} is used by default.

When method="fim", the FIM can be either estimated using a linearization of the model 
or a stochastic approximation. When method="proflike", the observed likelihood can be 
either estimated using a linearization of the model or an importance sampling Monte Carlo 
procedure. When method="bootstrap", the bootstrap estimates are obtained using the bootmlx
function
}
\examples{
# RsmlxDemo2.mlxtran is a Monolix project for modelling the PK of warfarin using a PK model 
# with parameters ka, V, Cl.

# confintmlx will compute a 90\% confidence interval for all the population parameters 
# using the population estimates obtained by Monolix and the Fisher Information Matrix 
# estimated by linearization
r1 <- confintmlx(project="RsmlxDemo2.mlxtran") 

# 95\% confidence intervals are now computed, using the FIM estimated by Monolix using a 
# stochastic approximation algorithm:
r2 <- confintmlx(project="RsmlxDemo2.mlxtran", linearization=FALSE, level=0.95) 

# Confidence intervals are computed for ka_pop and omega_ka only, 
# using the profile likelihood method:
r <- confintmlx(project    = "RsmlxDemo2.mlxtran", 
                method     = "proflike", 
                parameters = c("ka_pop","omega_ka")) 

# Confidence intervals are computed using 200 bootstrap samples:
r3 <- confintmlx(project="RsmlxDemo2.mlxtran", method="bootstrap", nboot=200)

# See http://rsmlx.webpopix.org/userguide/confintmlx/ for detailed examples of use of confintmlx
# Download the demo examples here: http://rsmlx.webpopix.org/installation


}
