% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rasubbo_orig}
\alias{rasubbo_orig}
\title{Produces a random sample from a Asymmetric Power Exponential distribution}
\usage{
rasubbo_orig(n, m = 0, al = 1, ar = 1, bl = 2, br = 2)
}
\arguments{
\item{n}{(int) - size of the sample.}

\item{m}{(numeric) - location parameter.}

\item{al, ar}{(numeric) - scale parameters.}

\item{bl, br}{(numeric) - shape parameters.}
}
\value{
a numeric vector containing a random sample.
}
\description{
Generate pseudo random-number from an asymmetric power exponential distribution
using the Tadikamalla method.
This codes is the original version of Bottazzi (2004)
}
\details{
The AEP distribution is expressed by the function:
\deqn{f(x;a_l,a_r,b_l,b_r,m) =
\frac{1}{A} e^{- \frac{1}{b_l} |\frac{x-m}{a_l}|^{b_l} }, x < m
}
\deqn{f(x;a_l,a_r,b_l,b_r,m) =
\frac{1}{A} e^{- \frac{1}{b_r} |\frac{x-m}{a_r}|^{b_r} }, x > m
}
with:
\deqn{A = a_lb_l^{1/b_l}\Gamma(1+1/b_l) + a_rb_r^{1/b_r}\Gamma(1+1/b_r)}
where \eqn{m} is a location parameter, \eqn{b*} are shape parameters, \eqn{a*}
are scale parameters and \eqn{\Gamma} representes the gamma function.
By a suitably transformation, it is possible to use the EP distribution with
the Tadikamalla method to sample from this distribution. We basically take
the absolute values of the numbers sampled from the \code{rpower} function,
which is equivalent from sampling from a half Exponential Power distribution.
These values are then weighted by a constant expressed in the parameters.
More details are available on the package vignette and on the
function \code{rpower}.
}
\examples{
sample_gamma <- rasubbo(1000, 0, 0.5, 0.5,  1, 1)
}
