% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimHS_maxI.R
\name{trimHS_maxI}
\alias{trimHS_maxI}
\title{Trims the H-S association matrix maximizing the incongruence}
\usage{
trimHS_maxI(N, HS, n, check.unique = TRUE)
}
\arguments{
\item{N}{Number of runs.}

\item{HS}{Host-Symbiont association matrix.}

\item{n}{Number of associations.}

\item{check.unique}{if \code{TRUE} discards duplicated trimmed matrices. This
alternative is recommended if \code{n} is small, because the
probability of obtaining the same trimmed matrix in different runs
increases as \code{n} decreases.}
}
\value{
A list of the N trimmed matrices.
}
\description{
For N runs, it randomly chooses \code{n} associations and trims the H-S
association matrix to include them, allowing both single and multiple
associations.
}
\examples{
data(nuc_cp)
N = 10  #for the example, we recommend 1e+4 value
n = 15
TNC <- trimHS_maxI(N, np_matrix, n, check.unique = TRUE)

}
