% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createHMM.R
\name{createHMM}
\alias{createHMM}
\title{Create a HMM model from corpus.}
\usage{
createHMM(trainvec, outputfolder = NULL, sensplit = "/w",
  wordsplit = "\\\\s+", natruesplit = "/", removestr = "^.*?/m")
}
\arguments{
\item{trainvec}{A character vector of corpus.}

\item{outputfolder}{The folder of output file. Defult is NULL.}

\item{sensplit}{Character containing regular expression to use for splitting sentence.}

\item{wordsplit}{Character containing regular expression to use for splitting words.}

\item{natruesplit}{Character containing regular expression to use for splitting nature.}

\item{removestr}{Character containing regular expression to use for removing string.}
}
\value{
a list from \code{\link[HMM]{initHMM}}.
}
\description{
Read a corpus vector and generate a HMM model file.
}
\examples{
data(PD980105)
m1 <- createHMM(PD980105[1:10])
names(m1)

}
