% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxJacobian.R
\name{.rxGenPred}
\alias{.rxGenPred}
\title{Generate Augmented pred/err RxODE model}
\usage{
.rxGenPred(obj, predfn, errfn, init, addProp = c("combined2", "combined1"))
}
\arguments{
\item{obj}{RxODE object}

\item{predfn}{Prediction function}

\item{errfn}{Error function}

\item{init}{Initialization parameters for scaling.}

\item{addProp}{one of "combined1" and "combined2"; These are the
two forms of additive+proportional errors supported by
monolix/nonmem:

combined1: transform(y)=transform(f)+(a+b*f^c)*eps

combined2: transform(y)=transform(f)+(a^2+b^2*f^(2c))*eps}
}
\value{
A list of (1) RxODE model variables augmented with
pred/error information and (2) extra error variables created.
}
\description{
Generate Augmented pred/err RxODE model
}
\author{
Matthew L Fidler
}
