% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/property.R
\name{prop_names}
\alias{prop_names}
\alias{prop_exists}
\title{Property introspection}
\usage{
prop_names(object)

prop_exists(object, name)
}
\arguments{
\item{object}{An object from a S7 class}

\item{name}{The name of the parameter as a character. Partial matching
is not performed.}
}
\value{
\code{prop_names()} returns a character vector; \code{prop_exists()} returns
a single \code{TRUE} or \code{FALSE}.
}
\description{
\itemize{
\item \code{prop_names(x)} returns the names of the properties
\item \code{prop_exists(x, "prop")} returns \code{TRUE} iif \code{x} has property \code{prop}.
}
}
\examples{
foo <- new_class("foo", properties = list(a = class_character, b = class_integer))
f <- foo()

prop_names(f)
prop_exists(f, "a")
prop_exists(f, "c")
}
