% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_S4_class_profile.R
\name{profile}
\alias{profile}
\alias{profile,Assessment-method}
\title{Profile likelihood of assessment models}
\usage{
profile(fitted, ...)

\S4method{profile}{Assessment}(fitted, figure = TRUE, ...)
}
\arguments{
\item{fitted, Assessment}{An object of class \linkS4class{Assessment}.}

\item{...}{A sequence of values of the parameter(s) for the profile. See details and example below.
See details for name of arguments to be passed on.}

\item{figure}{Logical, indicates whether a figure will be plotted.}
}
\value{
An object of class \linkS4class{prof} that contains a data frame of negative log-likelihood values from the profile and, optionally,
a figure of the likelihood surface.
}
\description{
Profile the likelihood for parameters of assessment models.
}
\details{
For the following assessment models, possible sequence of values for profiling are:
\itemize{
\item DD_TMB and DD_SS: \code{R0} and \code{h}
\item SP and SP_SS: \code{FMSY} and \code{MSY}
\item DD and cDD_SS: \code{R0} and \code{h}
\item SCA and SCA_Pope: \code{R0} and \code{h}
\item SCA2: \code{meanR}
\item VPA: \code{F_term}
\item SSS: \code{R0}
}
}
\examples{
\donttest{
output <- DD_TMB(Data = MSEtool::SimulatedData)

# Profile R0 only
pro <- profile(output, R0 = seq(100, 300, 10))

# Profile both R0 and steepness
pro <- profile(output, R0 = seq(100, 300, 10), h = seq(0.7, 0.9, 0.01))

# Ensure your grid is of proper resolution. A grid that is too coarse
# will likely distort the shape of the likelihood surface.
}
}
\author{
Q. Huynh
}
