% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_MPs.R
\name{make_MP}
\alias{make_MP}
\title{Make a custom management procedure (MP)}
\usage{
make_MP(.Assess, .HCR, diagnostic = c("min", "full", "none"), ...)
}
\arguments{
\item{.Assess}{Assessment model, a function of class \code{Assess}.}

\item{.HCR}{Harvest control rule, a function of class \code{HCR}.}

\item{diagnostic}{A character string describing if any additional diagnostic information from the
assessment models will be collected during the closed-loop simulation (\code{"none"} is the
default). \code{"min"} (minimal) will collect information on convergence and \code{"full"} will also collect the
model estimates of biomass and F generated by \code{.Assess}.}

\item{...}{Additional arguments to be passed to \code{.Assess} and \code{.HCR}.}
}
\value{
A function of class \code{MP}.
}
\description{
Function operator that combines a function of class \code{Assess} and a function of
class \code{HCR} to create a management procedure (MP). The resulting function
can then be tested in closed-loop simulation via \code{\link[MSEtool]{runMSE}}.
}
\examples{
# A statistical catch-at-age model with a 40-10 control rule
SCA_40_10 <- make_MP(SCA, HCR40_10)

# An SCA that will produce convergence diagnostics
SCA_40_10 <- make_MP(SCA, HCR40_10, diagnostic = "min")

# MP with an SCA that uses a Ricker stock-recruit function.
SCA_Ricker <- make_MP(SCA, HCR_MSY, SR = "Ricker")
show(SCA_Ricker)

}
\seealso{
\link{HCR_ramp} \link{HCR_MSY} \link{diagnostic} \link{retrospective_AM}
}
