% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc.CDFt.R
\name{CDFt}
\alias{CDFt}
\title{CDFt method (Cumulative Distribution Function transfer)}
\description{
Perform an univariate bias correction of X with respect to Y.
}
\details{
Correction is applied margins by margins.
}
\examples{
## Three bivariate random variables (rnorm and rexp are inverted between ref and bias)
XY = SBCK::dataset_gaussian_exp_2d(2000)
X0 = XY$X0 ## Biased in calibration period
Y0 = XY$Y0 ## Reference in calibration period
X1 = XY$X1 ## Biased in projection period

## Bias correction
## Step 1 : construction of the class CDFt 
cdft = SBCK::CDFt$new() 
## Step 2 : Fit the bias correction model
cdft$fit( Y0 , X0 , X1 )
## Step 3 : perform the bias correction, Z is a list containing
## corrections
Z = cdft$predict(X1,X0) 
Z$Z0 ## Correction in calibration period
Z$Z1 ## Correction in projection period
}
\references{
Michelangeli, P.-A., Vrac, M., and Loukos, H.: Probabilistic 
            downscaling approaches: Application to wind cumulative 
            distribution functions, Geophys. Res. Lett., 36, L11708, 
            https://doi.org/10.1029/2009GL038401, 2009.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{n_features}}{[integer] Number of features}

\item{\code{tol}}{[double] Floatting point tolerance}

\item{\code{distY0}}{[ROOPSD distribution or a list of them] Describe the law of
each margins. A list permit to use different laws for each
margins. Default is ROOPSD::rv_histogram.}

\item{\code{distY1}}{[ROOPSD distribution or a list of them] Describe the law of
each margins. A list permit to use different laws for each
margins. Default is ROOPSD::rv_histogram.}

\item{\code{distX0}}{[ROOPSD distribution or a list of them] Describe the law of
each margins. A list permit to use different laws for each
margins. Default is ROOPSD::rv_histogram.}

\item{\code{distX1}}{[ROOPSD distribution or a list of them] Describe the law of
each margins. A list permit to use different laws for each
margins. Default is ROOPSD::rv_histogram.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CDFt-new}{\code{CDFt$new()}}
\item \href{#method-CDFt-fit}{\code{CDFt$fit()}}
\item \href{#method-CDFt-predict}{\code{CDFt$predict()}}
\item \href{#method-CDFt-clone}{\code{CDFt$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CDFt-new"></a>}}
\if{latex}{\out{\hypertarget{method-CDFt-new}{}}}
\subsection{Method \code{new()}}{
Create a new CDFt object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CDFt$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional arguments are:
- distX0, distX1, models in calibration and projection period, see ROOPSD
- distY0, distY1, observations in calibration and projection period, see ROOPSD
- kwargsX0, kwargsX1, list of arguments for each respective distribution
- kwargsY0, kwargsY1, list of arguments for each respective distribution
- scale_left_tail [float]  Scale applied on the left support
  (min to median) between calibration and projection period. If
  NULL (default), it is determined during the fit. If == 1,
  equivalent to the original algorithm of CDFt.
- scale_right_tail [float]  Scale applied on the right support
  (median to max) between calibration and projection period. If
  NULL (default), it is determined during the fit. If == 1,
  equivalent to the original algorithm of CDFt.
- normalize_cdf [bool or vector of bool] If a normalization
  is applied to the data to maximize the overlap of the
  support. Can be a bool (True or False, applied for all
  colums), or a list of bool of size 'n_features' to
  distinguished each columns.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `CDFt` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CDFt-fit"></a>}}
\if{latex}{\out{\hypertarget{method-CDFt-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the bias correction method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CDFt$fit(Y0, X0, X1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y0}}{[matrix: n_samples * n_features] Observations in calibration}

\item{\code{X0}}{[matrix: n_samples * n_features] Model in calibration}

\item{\code{X1}}{[matrix: n_samples * n_features] Model in projection}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CDFt-predict"></a>}}
\if{latex}{\out{\hypertarget{method-CDFt-predict}{}}}
\subsection{Method \code{predict()}}{
Predict the correction
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CDFt$predict(X1, X0 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X1}}{[matrix: n_samples * n_features] Model in projection}

\item{\code{X0}}{[matrix: n_samples * n_features or NULL] Model in calibration}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[matrix or list] Return the matrix of correction of X1 if X0 is
                         NULL, else return a list containing Z1 and Z0,
                         the corrections of X1 and X0
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CDFt-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CDFt-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CDFt$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
