% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blockmod.R
\name{multinom}
\alias{multinom}
\title{Multinomial block assignment}
\usage{
multinom(gamma, kappa)
}
\arguments{
\item{gamma}{parameter for Dirichlet component \eqn{Dirichlet(gamma, ..., gamma)}}

\item{kappa}{the number of blocks}
}
\value{
a block model representing a \code{Multinomial(gamma)} distribution
}
\description{
A \code{\link{blockmod}} for Multinomial allocation
}
\details{
This model posits that: for \code{i=1:n}
\deqn{Z_i ~ Multinomial(omega)}
where
\deqn{omega ~ Dirichlet(gamma)}
}
\examples{
## A fixed number of blocks with multinomial assignment of nodes
m <- multinom(1, 4)
print(m)
m$r(10) ## simulate a blocks object with 10 nodes
}
