% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_prediction.R
\name{simulation_prediction}
\alias{simulation_prediction}
\title{Simulate Longitudinal Data for Prediction}
\usage{
simulation_prediction(
  n_subject = 800,
  seed = NULL,
  nonlinear = FALSE,
  nonrandeff = FALSE,
  nonresidual = FALSE
)
}
\arguments{
\item{n_subject}{Number of subjects in the dataset. Each subject has multiple observations across 6 follow-up time points. Default: \code{800}.}

\item{seed}{Random seed for reproducibility. Ensures different training-testing splits. Default: \code{123}.}

\item{nonlinear}{Logical value indicating whether the outcome model includes nonlinear associations. Default: \code{FALSE}.}

\item{nonrandeff}{Logical value indicating whether the random effects are non-normal. Default: \code{FALSE}.}

\item{nonresidual}{Logical value indicating whether the residuals are non-normal. Default: \code{FALSE}.}
}
\value{
A list containing:
\describe{
\item{\code{Y_test_true}}{True values of the vector of outcomes in the testing set.}
\item{\code{X_train}}{Matrix of covariates in the training set.}
\item{\code{Y_train}}{Vector of outcomes in the training set.}
\item{\code{Z_train}}{Matrix of random predictors in the training set.}
\item{\code{subject_id_train}}{Vector of subject IDs in the training set.}
\item{\code{time_train}}{Vector of time point in the training set.}
\item{\code{X_test}}{Matrix of covariates in the testing set.}
\item{\code{Y_test}}{Vector of outcomes in the testing set.}
\item{\code{Z_test}}{Matrix of random predictors in the testing set.}
\item{\code{subject_id_test}}{Vector of subject IDs in the testing set.}
\item{\code{time_test}}{Vector of time point in the testing set.}
}
}
\description{
Generates a fixed population longitudinal dataset, with random seeds to generate different
training and testing sets. The function supports customization of linear/nonlinear associations,
normal/non-normal random effects, and random errors. It splits the data into training and testing sets,
with the testing set comprising approximately 40\% of the data.
}
\details{
The function creates a dataset with individuals observed at 6 follow-up time points. It allows
users to specify whether the associations are linear or nonlinear and whether random effects and residuals
follow normal or non-normal distributions. Approximately 40\% of the data is randomly chosen to form the
testing set, while the remaining 60\% constitutes the training set.
}
\examples{
  # Generate data with nonlinear associations and non-normal random effects and residuals
  data <- simulation_prediction(
    n_subject = 800,
    seed = 123,
    nonlinear = TRUE,
    nonrandeff = TRUE,
    nonresidual = TRUE
  )
  # Access training and testing data
  X_train <- data$X_train
  Y_train <- data$Y_train
  Z_train <- data$Z_train
  subject_id_train <- data$subject_id_train

  X_test <- data$X_test
  Y_test <- data$Y_test
  Z_test <- data$Z_test
  subject_id_test <- data$subject_id_test
  
  Y_test_true = data$Y_test_true

}
\seealso{
\code{\link[mvtnorm]{Mvnorm}}
\code{\link[stats]{Chisquare}}
\code{\link[mice]{ampute}}
}
