% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SC-MEB.R
\name{SC.MEB}
\alias{SC.MEB}
\title{SC.MEB.}
\usage{
SC.MEB(
  y,
  Adj_sp,
  beta_grid = seq(0, 4, 0.2),
  K_set = 2:10,
  parallel = TRUE,
  num_core = 5,
  PX = TRUE,
  maxIter_ICM = 10,
  maxIter = 50
)
}
\arguments{
\item{y}{is n-by-d PCs.}

\item{Adj_sp}{is a sparse matrix of neighborhood. It is often generated from function find_neighbors2 or getneighborhood_fast.}

\item{beta_grid}{is a numeric vector specifying the smoothness parameter of Random Markov Field. The default is seq(0,4,0.2).}

\item{K_set}{is an integer vector specifying the numbers of mixture components (clusters) for which the BIC is to be calculated. The default is K = 2:10.}

\item{parallel}{is a logical value to decide whether the function SC.MEB run in parallel. The default is TRUE.}

\item{num_core}{is an integer value to decide how many cores are used to run SC.MEB in parallel.}

\item{PX}{is a logical value to decide whether to use parameter expansion in EM algorithm}

\item{maxIter_ICM}{is the maximum iteration of ICM algorithm. The default is 10.}

\item{maxIter}{is the maximum iteration of EM algorithm. The default is 50.}
}
\value{
a list, We briefly explain the output of the SC.MEB. 
 
The item 'x' contains clustering results.

The item 'gam' is the posterior probability matrix.

The item 'ell' is the opposite log-likelihood. 

The item 'mu' is the mean of each component.

The item 'sigma' is the variance of each component.
}
\description{
SC.MEB implements the model SC-MEB, spatial clustering with hidden Markov random field using empirical Bayes.
}
\details{
SC.MEB can implements the model SC-MEB in parallel which can improve the speed of the computation.
}
\examples{
y = matrix(rnorm(50, 0, 1), 25,2)
pos = cbind(rep(1:5, each=5), rep(1:5, 5))
Adj_sp = getneighborhood_fast(pos, 1.2)
beta_grid = c(0.5,1)
K_set = 2:3
out = SC.MEB(y, Adj_sp, beta_grid, K_set, TRUE, 2)
}
\references{
Yang Y, Shi X, Zhou Q, et al. SC-MEB: spatial clustering with hidden Markov random field using empirical Bayes[J]. bioRxiv, 2021.
}
