#' Permutation Test
#'
#' @param fullcluster A list of clusters that generated by the function GetCluster()
#' @param firstn The number of nearest cells were detected that you want to include in the permutation test.
#' @param distmat A list of distance vectors generated by the function FindNNDist().
#'
#' @return A list of two lists, one is the relative within-between distance and another is p-value of permutation test. Default to be 15.
#' @export
#'
#' @examples
#' data(sim_result)
#' testres <- PermTest(sim_result[[1]], sim_result[[3]],15)

PermTest <- function(fullcluster, distmat, firstn){

  stopifnot(exprs = {
    is.list(fullcluster)
    is.list(distmat)
    is.numeric(firstn)
  })


  allP <- list()

  nclust <- rep(NA, length(fullcluster))

  for(i in 1:length(fullcluster)) {
    nclust[i] <- max(fullcluster[[i]]$finecluster)
  }

  allrevDiff <- matrix(NA, max(nclust), length(fullcluster))

  for (j in 1:length(fullcluster)){

    revDiff <- rep(NA, nclust[j])
    onep_vec <- rep(NA, length(distmat[[j]][[1]]))

    for (q in 1:nclust[j]){

      dist1 <- as.vector(do.call(cbind, distmat[[j]][[1]][[q]])[,1:firstn])
      dist2 <- as.vector(do.call(cbind, distmat[[j]][[2]][[q]])[,1:firstn])

      revDiff[q] <- (mean(dist2) - mean(dist1))/max(mean(dist2),mean(dist1))

      # disttest <- data.frame(rbind(cbind(dist1,rep("Internal Dist",length(dist1))),
      #                              cbind(dist2,rep("External Dist",length(dist2)))))%>%
      #   dplyr::mutate(dist = as.numeric(dist1),group = factor(V2)) %>% dplyr::select(3,4)

      # Using Native Pipe
      # disttest <- data.frame(rbind(cbind(dist1, rep("Internal Dist", length(dist1))),
      #                              cbind(dist2, rep("External Dist", length(dist2))))) |>
      #   (\(df) dplyr::mutate(df, dist = as.numeric(dist1), group = factor(V2)))() |>
      #   (\(df) dplyr::select(df, 3, 4))()

      # Without Pipes
      dist_combined <- data.frame(rbind(cbind(dist1, rep("Internal Dist", length(dist1))),
                                        cbind(dist2, rep("External Dist", length(dist2)))))
      disttest <- dplyr::mutate(dist_combined, dist = as.numeric(dist1), group = factor(V2))
      disttest <- dplyr::select(disttest, 3, 4)


      onep_vec[q] <- round(coin::pvalue(coin::independence_test(dist ~ group, data = disttest,
                                                    alternative = "greater")),3)


    }

    allrevDiff[1:nclust[j], j] <- revDiff
    allP[[j]] <- onep_vec

  }

  return(list(allrevDiff = allrevDiff,
              allP = allP))

}
