% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCRIPsimDE.R
\name{simu_DE}
\alias{simu_DE}
\title{SCRIP simulation for differential expression}
\usage{
simu_DE(
  expre_data,
  params,
  nGenes = NULL,
  nDE,
  ncells = NULL,
  FC,
  Dropout_rate = NULL,
  libsize = NULL,
  pre.bcv.df = NULL,
  bcv.shrink = 1,
  seed = 2021
)
}
\arguments{
\item{expre_data}{data matrix required for simulation}

\item{params}{SplatParams object containing parameters for the simulation}

\item{nGenes}{number of genes simulated}

\item{nDE}{number of differentially expressed genes simulated}

\item{ncells}{number of cells simulated}

\item{FC}{fold change rate simulated between two groups}

\item{Dropout_rate}{factor to control the dropout rate directly}

\item{libsize}{library size used for simulation}

\item{pre.bcv.df}{BCV.df enables us to change the variation of BCV values}

\item{bcv.shrink}{factor to control the BCV levels}

\item{seed}{seed for simulation}
}
\value{
SummarizedExperiment files from both groups for DE analysis and DE genes index
}
\description{
Simulate count data for differential expression analysis using SCRIP
}
