% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_ColorPalette.R
\name{do_ColorPalette}
\alias{do_ColorPalette}
\title{Generate color scales based on a value.}
\usage{
do_ColorPalette(
  colors.use,
  n = 12,
  opposite = FALSE,
  adjacent = FALSE,
  triadic = FALSE,
  split_complementary = FALSE,
  tetradic = FALSE,
  square = FALSE,
  complete_output = FALSE,
  plot = FALSE,
  font.size = 14,
  font.type = "sans"
)
}
\arguments{
\item{colors.use}{\strong{\code{\link[base]{character}}} | One color upon which generate the color scale. Can be a name or a HEX code.}

\item{n}{\strong{\code{\link[base]{numeric}}} | Number of colors to include in the color wheel. Use it when all other options are FALSE, otherwise, it becomes 12.}

\item{opposite}{\strong{\code{\link[base]{logical}}} | Return the opposing color to the one provided.}

\item{adjacent}{\strong{\code{\link[base]{logical}}} | Return the adjacent colors to the one provided.}

\item{triadic}{\strong{\code{\link[base]{logical}}} | Return the triadic combination of colors to the one provided.}

\item{split_complementary}{\strong{\code{\link[base]{logical}}} | Return the split complementary combination of colors to the one provided.}

\item{tetradic}{\strong{\code{\link[base]{logical}}} | Return the tetradic combination of colors to the one provided.}

\item{square}{\strong{\code{\link[base]{logical}}} | Return the square combination of colors to the one provided.}

\item{complete_output}{\strong{\code{\link[base]{logical}}} | Runs all the previous options and returns all the outputs as a list that contains all color vectors, all plots and a combined plot with everything.}

\item{plot}{\strong{\code{\link[base]{logical}}} | Whether to also return a plot displaying the values instead of a vector with the color.}

\item{font.size}{\strong{\code{\link[base]{numeric}}} | Overall font size of the plot. All plot elements will have a size relationship with this font size.}

\item{font.type}{\strong{\code{\link[base]{character}}} | Base font family for the plot. One of:
\itemize{
\item \emph{\code{mono}}: Mono spaced font.
\item \emph{\code{serif}}: Serif font family.
\item \emph{\code{sans}}: Default font family.
}}
}
\value{
A character vector with the desired color scale.
}
\description{
This function is an adaptation of colortools package. As the package was removed from CRAN on 23-06-2022, this utility function came to existence in order to cover the gap. It is, on its basis,
an adaptation of the package into a single function. Original code, developed by Gaston Sanchez, can be found in: \url{https://github.com/gastonstat/colortools}
}
\examples{
\donttest{
  # Check Suggests.
  value <- SCpubr:::check_suggests(function_name = "do_ColorPalette", passive = TRUE)
  
  if (isTRUE(value)){
    # Generate a color wheel based on a single value.
    colors <- SCpubr::do_ColorPalette(colors.use = "steelblue")
    p <- SCpubr::do_ColorPalette(colors.use = "steelblue",
                                 plot = TRUE)
  
    # Generate a pair of opposite colors based on a given one.
    colors <- SCpubr::do_ColorPalette(colors.use = "steelblue",
                                      opposite = TRUE)
    p <- SCpubr::do_ColorPalette(colors.use = "steelblue",
                                 opposite = TRUE,
                                 plot = TRUE)
  
    # Generate a trio of adjacent colors based on a given one.
    colors <- SCpubr::do_ColorPalette(colors.use = "steelblue",
                                      adjacent = TRUE)
    p <- SCpubr::do_ColorPalette(colors.use = "steelblue",
                                 adjacent = TRUE,
                                 plot = TRUE)
  
    # Generate a trio of triadic colors based on a given one.
    colors <- SCpubr::do_ColorPalette(colors.use = "steelblue",
                                      triadic = TRUE)
    p <- SCpubr::do_ColorPalette(colors.use = "steelblue",
                                 triadic = TRUE,
                                 plot = TRUE)
  
    # Generate a trio of split complementary colors based on a given one.
    colors <- SCpubr::do_ColorPalette(colors.use = "steelblue",
                                      split_complementary = TRUE)
    p <- SCpubr::do_ColorPalette(colors.use = "steelblue",
                                 split_complementary = TRUE,
                                 plot = TRUE)
  
    # Generate a group of tetradic colors based on a given one.
    colors <- SCpubr::do_ColorPalette(colors.use = "steelblue",
                                      tetradic = TRUE)
    p <- SCpubr::do_ColorPalette(colors.use = "steelblue",
                                 tetradic = TRUE,
                                 plot = TRUE)
  
    # Generate a group of square colors based on a given one.
    colors <- SCpubr::do_ColorPalette(colors.use = "steelblue",
                                      square = TRUE)
    p <- SCpubr::do_ColorPalette(colors.use = "steelblue",
                                 square = TRUE,
                                 plot = TRUE)
  
    # Retrieve the output of all options.
    out <- SCpubr::do_ColorPalette(colors.use = "steelblue",
                                   complete_output = TRUE)
    ## Retrieve the colors.
    colors <- out$colors
    ## Retrieve the plots.
    plots <- out$plots
    ## Retrieve a combined plot with all the options.
    p <- out$combined_plot
  
  } else if (base::isFALSE(value)){
    message("This function can not be used without its suggested packages.")
    message("Check out which ones are needed using `SCpubr::state_dependencies()`.")
  }
}
}
