% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_functions.R
\name{SDALGCPCreatePoint}
\alias{SDALGCPCreatePoint}
\title{SDALGCPCreatePoint function}
\usage{
SDALGCPCreatePoint(my_shp, delta, weighted = FALSE, lambdamax = NULL,
  pop = NULL, pop_shp = NULL, n = NULL, method = 1, plot = FALSE,
  rho = NULL, giveup = NULL)
}
\arguments{
\item{my_shp}{A SpatialPolygons or SpatialPolygonsDataFrame  object containing the polygons (i.e each regions).}

\item{delta}{distance between points}

\item{weighted}{To specify if you want to use the population density, default to FALSE, i.e population density is not used.}

\item{lambdamax}{the maximum value of the population density in the polygon.}

\item{pop}{the population density.}

\item{pop_shp}{Optional, The raster of population density map for population weighted approach.}

\item{n}{optional; the number of points to create in the polygon, if not supplied, it is computed as \eqn{n = rho*|A|*4/(\pi*delta^2)}}

\item{method}{To specify which method to use to sample the points, the options are 1 for Simple Sequential Inhibition (SSI) process, 2 for Uniform sampling and 3 for regular grid. 1 is the default}

\item{plot}{To display the plot of the points inside the polygon, default to TRUE.}

\item{rho}{Optional, The packing density, default set to 0.55}

\item{giveup}{Number of rejected proposals after which the algorithm should terminate.}
}
\value{
It returns a list of the coordinates of the points created in each polygon and it has an associated attribute weighted which is either TRUE or FALSE to indicate if the population density is used or not.
}
\description{
This wrapper function generate a random point pattern using Simple Sequential Inhibition (SSI) process, uniform sampling and regular grid point.
}
\details{
This algorithm generates points inside the polygon using three algorithms specified in the method.
}
\seealso{
\link{SDALGCPSSIPoint}, \link{SDALGCPUniformPoint}, \link{SDALGCPRegularPoint}
}
\author{
Olatunji O. Johnson \email{o.johnson@lancaster.ac.uk}

Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
\keyword{internal}
