% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/leerDatos.R
\name{read.keel}
\alias{read.keel}
\title{Reads a KEEL format file}
\usage{
read.keel(file, nLabels = 3)
}
\arguments{
\item{file}{The path of the file in KEEL format}

\item{nLabels}{The number of fuzzy labels to create on numerical variables.}
}
\description{
This function reads a KEEL dataset file and store the information
  in a \code{keel} class. This function also create fuzzy sets definitions
  for execute in SDIGA, MESDIF or NMEEF-SD algorithms
}
\details{
A KEEL data file must have the following structure:
 \itemize{
   \item{ @relation: Name of the data set }
   \item{ @attribute: Description of an attribute (one for each attribute)}
   \item{ @inputs: List with the names of the input attributes }
   \item{ @output: Name of the output attribute (Not used in this algorithms implementation) }
   \item{ @data: Starting tag of the data}
}
   The rest of the file contains all the examples belonging to the data set, expressed in comma sepparated values format.
}
\examples{
\dontrun{
       Reads a KEEL dataset from a file.
       read.keel(file = "C:\\KEELFile.txt")

       read.keel(file = "C:\\KEELFile.txt", nLabels = 7)
    }
}
\author{
Angel M. Garcia <amgv0009@red.ujaen.es>
}
\references{
J. Alcala-Fdez, A. Fernandez, J. Luengo, J. Derrac, S. Garcia, L. Sanchez, F. Herrera. KEEL Data-Mining Software Tool: Data Set Repository, Integration of Algorithms and Experimental Analysis Framework. Journal of Multiple-Valued Logic and Soft Computing 17:2-3 (2011) 255-287.
}
\seealso{
KEEL Dataset Repository (Standard Classification): \url{http://sci2s.ugr.es/keel/category.php?cat=clas}
}

