#  SEMgraph library
#  Copyright (C) 2019-2021 Fernando Palluzzi; Mario Grassi
#  e-mail: <fernando.palluzzi@gmail.com>
#  University of Pavia, Department of Brain and Behavioral Sciences
#  Via Bassi 21, 27100 Pavia, Italy

#  SEMgraph is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.

#  SEMgraph is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <https://www.gnu.org/licenses/>.

# -------------------------------------------------------------------- #


#' @title KEGG interactome
#'
#' @description Interactome generated by merging KEGG pathways 
#' extracted using the \code{graphite} R package (update: April, 2020).
#' @name kegg
#' @usage kegg
#' @docType data
#' @format
#' "kegg" is an igraph network object of 5934 nodes and 77158 edges 
#' corresponding to the union of 306 KEGG pathways.
#' @source \url{https://www.genome.jp/kegg/}
#' @references
#' 
#' Kanehisa M, Goto S (1999). KEGG: kyoto encyclopedia of genes and genomes. 
#' Nucleic Acid Research 28(1): 27-30. 
#' <https://doi.org/10.1093/nar/27.1.29>
#'
#' Martini P, Sales G, Massa MS, Chiogna M, Romualdi C. Along signal paths: 
#' anempirical gene set approach exploiting pathway topology. 
#' Nucleic Acids Res. 41(1):e19.
#' <https://doi.org/10.1093/nar/gks866>
#' 
#' @examples
#' 
#' \donttest{
#' library(igraph)
#' 
#' # KEGG graph
#' summary(kegg)
#' 
#' # KEGG degrees of freedom
#' vcount(kegg)*(vcount(kegg) - 1)/2 - ecount(kegg)
#' 
#' # KEGG average shortest path length
#' mean_distance(kegg)
#' 
#' }
#'

NULL
