% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semLatent.R
\name{clusterScore}
\alias{clusterScore}
\title{Module scoring}
\usage{
clusterScore(
  graph,
  data,
  group,
  HM = "LV",
  type = "wtc",
  size = 5,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{graph}{An igraph object.}

\item{data}{A matrix or data.frame. Rows correspond to subjects, and
columns to graph nodes.}

\item{group}{A binary vector. This vector must be as long as the number
of subjects. Each vector element must be 1 for cases and 0 for control
subjects.}

\item{HM}{Hidden model type. For each defined hidden module:
(i) if \code{HM = "LV"}, a latent variable (LV) will be defined as
common unknown cause acting on cluster nodes; (ii) if \code{HM = "CV"},
cluster nodes will be considered as regressors of a latent composite
variable (CV); (iii) if \code{HM = "UV"}, an unmeasured variable (UV)
model will be generated for each module, where source nodes (i.e.,
in-degree = 0) act as common regressors influencing the other nodes
via an unmeasured variable.}

\item{type}{Graph clustering method. If \code{type = "tahc"}, network
modules are generated using the tree agglomerative hierarchical
clustering method (Yu et al., 2015).
Other non-tree clustering methods from igraph package include: "wtc"
(default value; walktrap community structure with short random walks),
"ebc" (edge betweeness clustering), "fgc" (fast greedy method), "lbc"
(label propagation method), "lec" (leading eigenvector method), "loc"
(multi-level optimization), "opc" (optimal communiy structure), "sgc"
(spinglass statistical mechanics).
By default, the "wtc" method is used.}

\item{size}{Minimum number of nodes per hidden module. By default, a
minimum number of 5 nodes is required.
By default, HM is set to "LV" (i.e., the latent variable model).}

\item{verbose}{A logical value. If TRUE, intermediate graphs will be
displayed during the execution. In addition, a condensed graph with
clusters as nodes will be fitted and showed to screen (see also
\code{\link[SEMgraph]{mergeNodes}}). By default, \code{verbode = FALSE}.}

\item{...}{Currently ignored.}
}
\value{
A list of 3 objects:
\enumerate{
\item "fit", hidden module fitting as a lavaan object;
\item "membership", hidden module nodes membership;
\code{\link[SEMgraph]{clusterGraph}} function;
\item "dataHM", hidden module data matrix with cluster scores.
}
}
\description{
Generate factor scores, principal component scores, or
projection scores of latent, composite, and unmeasured variable modules,
respectively, and fit them in a SEM with exogenous group effect.
}
\examples{

library(huge)
als.npn <- huge.npn(alsData$exprs)

C <- clusterScore(graph = alsData$graph, data = als.npn,
                  group = alsData$group,
                  HM = "LV",
                  type = "wtc",
                  verbose = TRUE)
summary(C$fit)
head(C$dataHM)
table(C$membership)

}
\references{
Palluzzi F, Grassi M (2021). SEMgraph: An R Package for Causal Network
Analysis of High-Throughput Data with Structural Equation Models.
<arXiv:2103.08332>
}
\seealso{
See \code{\link[SEMgraph]{clusterGraph}} and \code{\link[SEMgraph]{cplot}}
for graph clustering, and \code{\link[cate]{factor.analysis}} for
factor analysis.
}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
