% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semUtils.R
\name{SEMdci}
\alias{SEMdci}
\title{SEM-based differential connectivity inference (DCI)}
\usage{
SEMdci(graph, data, group, C = "none", method = "BH", alpha = 0.05, ...)
}
\arguments{
\item{graph}{Input network as an igraph object.}

\item{data}{A matrix or data.frame. Rows correspond to subjects, and
columns to graph nodes (variables).}

\item{group}{A binary vector. This vector must be as long as the number
of subjects. Each vector element must be 1 for cases and 0 for control
subjects.}

\item{C}{Topological clustering methods (default C = "none"). If
\code{type = "tahc"}, network modules are generated using the tree
agglomerative hierarchical clustering method (Yu et al., 2015).
Other non-tree clustering methods from igraph package include: "wtc"
(walktrap community structure with short random walks),
"ebc" (edge betweeness clustering), "fgc" (fast greedy method), "lbc"
(label propagation method), "lec" (leading eigenvector method), "loc"
(multi-level optimization), "opc" (optimal community structure), "sgc"
(spinglass statistical mechanics).}

\item{method}{Multiple testing correction method. One of the values
available in \code{\link[stats]{p.adjust}}. By default, method is set
to "BH" (i.e., Benjamini-Hochberg correction).}

\item{alpha}{Gene set test significance level (default = 0.05).}

\item{...}{Currently ignored.}
}
\value{
An igraph object.
}
\description{
Creates a network with perturbed edges obtained from 
the output of \code{\link[SEMgraph]{SEMrun}} with two-group and CGGM solver.
To increase the efficiency of computations for large graphs,
users can select to break the network structure into clusters and select
the topological clustering method (see \code{\link[SEMgraph]{clusterGraph}}). 
The function \code{\link[SEMgraph]{SEMrun}} is applied iteratively on 
each cluster to obtain the graph with the full list of perturbed edges.
}
\examples{

\dontrun{

# Nonparanormal(npn) transformation
library(huge)
als.npn <- huge.npn(alsData$exprs)

g <- kegg.pathways[["MAPK signaling pathway"]]
G <- properties(g)[[1]]; summary(G)

# Create ALS network with perturbed edges using edge betweeness clustering
gU<- SEMdci(G, als.npn, alsData$group, C="ebc", method="BH", alpha=0.2)
gcU<- properties(gU)

old.par <- par(no.readonly = TRUE)
par(mfrow=c(2,2), mar=rep(1,4))
gplot(gcU[[1]], l="fdp") # max component
gplot(gcU[[2]], l="fdp") # 2nd cpmponent
gplot(gcU[[3]], l="fdp") # 3rd component 
gplot(gcU[[4]], l="fdp") # 4th component
par(old.par)

}

}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
