% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semUtils.R
\name{SEMgsa}
\alias{SEMgsa}
\title{SEM-based gene set analysis (GSA)}
\usage{
SEMgsa(g = list(), data, group, method = "BH", alpha = 0.05, n_rep = 1000, ...)
}
\arguments{
\item{g}{A list of pathways to be tested.}

\item{data}{A matrix or data.frame. Rows correspond to subjects, and
columns to graph nodes (variables).}

\item{group}{A binary vector. This vector must be as long as the number
of subjects. Each vector element must be 1 for cases and 0 for control
subjects.}

\item{method}{Multiple testing correction method. One of the values
available in \code{\link[stats]{p.adjust}}. By default, method is set
to "BH" (i.e., Benjamini-Hochberg correction).}

\item{alpha}{Gene set test significance level (default = 0.05).}

\item{n_rep}{Number of randomization replicates (default = 1000).}

\item{...}{Currently ignored.}
}
\value{
A list of 2 objects:
\enumerate{
\item "gsa", A data.frame reporting the following information for each
pathway in the input list:
\itemize{
\item "No.nodes", pathway size (number of nodes);
\item "No.DEGs", number of differential espression genes (DEGs) within
the pathway, after multiple test correction with one of the methods
available in \code{\link[stats]{p.adjust}};
\item "pert", pathway perturbation status (see details);
\item "pNA", Brown's combined P-value of pathway node activation;
\item "pNI", Brown's combined P-value of pathway node inhibition;
\item "PVAL", Bonferroni combined P-value of pNA, and pNI; i.e.,
2* min(pNA, PNI);
\item "ADJP", Adjusted Bonferroni P-value of pathway perturbation; i.e.,
min(No.pathways * PVAL; 1).
}
\item "DEG", a list with DEGs names per pathways.
}
}
\description{
Gene Set Analysis (GSA) via self-contained test for group
effect on signaling (directed) pathways based on SEM. The core of the
methodology is implemented in the RICF algorithm of \code{SEMrun()},
recovering from RICF output node-specific group effect p-values, and
Brown’s combined permutation p-values of node activation and inhibition.
}
\details{
For gaining more biological insights into the functional roles
of pre-defined subsets of genes, node perturbation obtained from RICF
fitting has been combined with up- or down-regulation of genes from KEGG
to obtain overall pathway perturbation as follows: 
\itemize{
\item The node perturbation is defined as activated when the minimum among
the p-values is positive; if negative, the status is inhibited. 
\item Up- or down- regulation of genes (derived from KEGG database) has
been obtained from the weighted adjacency matrix of each pathway as column
sum of weights over each source node. If the overall sum of node weights
is below 1, the pathway is flagged as down-regulated otherwise as up-regulated. 
\item The combination between these two quantities allows to define the
direction (up or down) of gene perturbation. Up- or down regulated gene status,
associated with node inhibition, indicates a decrease in activation (or
increase in inhibition) in cases with respect to control group. Conversely,
up- or down regulated gene status, associated with node activation, indicates
an increase in activation (or decrease in inhibition) in cases with
respect to control group.
}
}
\examples{

\dontrun{

# Nonparanormal(npn) transformation

library(huge)
als.npn <- huge.npn(alsData$exprs)

# Selection of FTD-ALS pathways from kegg.pathways.Rdata

paths.name <- c("MAPK signaling pathway",
                "Protein processing in endoplasmic reticulum",
                "Endocytosis",
                "Wnt signaling pathway",
                "Neurotrophin signaling pathway",
                "Amyotrophic lateral sclerosis")

j <- which(names(kegg.pathways) \%in\% paths.name)

GSA <- SEMgsa(kegg.pathways[j], als.npn, alsData$group,
              method = "bonferroni", alpha = 0.05,
              n_rep = 1000)
GSA$gsa
GSA$DEG

}

}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
