% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{SEQdata.multitreatment}
\alias{SEQdata.multitreatment}
\title{Simulated multitreatment example data for \code{\link[=SEQuential]{SEQuential()}} multinomial models}
\format{
A dataframe with 5,976 rows and 11 columns:
\describe{
\item{ID}{Integer: Unique ID emulating individual patients}
\item{time}{Integer: Time of observation, always begins at 0, max time of 59; however, if lost-to-followup, time is truncated at a random point}
\item{eligible}{Binary: eligibility criteria for timepoints}
\item{outcome}{Binary: If an outcome is observed at this time point}
\item{tx_init}{Integer: Which treatment is observed at this time point}
\item{sex}{Binary: Sex of the emulated patient}
\item{N}{Numeric: Normal random variable from N(10,5)}
\item{L}{Numeric: 4\% continuously increase from U(0, 1)}
\item{P}{Numeric: 2\% continuously decrease from U(9, 10)}
\item{excusedOne}{Binary: Once one, always one variable emulating an excuse for treatment switch}
\item{excusedZero}{Binary: Once zero, always zero variable emulating an excuse for treatment switch}
}
}
\usage{
SEQdata.multitreatment
}
\description{
Simulated multitreatment example data for \code{\link[=SEQuential]{SEQuential()}} multinomial models
}
\keyword{datasets}
