% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniform.R
\name{uniform.crit}
\alias{uniform.crit}
\title{Uniform criterion}
\usage{
uniform.crit(design)
}
\arguments{
\item{design}{a design matrix.}
}
\value{
wrap-around discrepancy of the design
}
\description{
This function calculates the wrap-around discrepancy of a design.
}
\details{
\code{uniform.crit} calculates the wrap-around discrepancy of a design. The wrap-around discrepancy for a design \eqn{D=[\bm x_1, \dots, \bm x_n]^T} is defined as (Hickernell, 1998):
\deqn{\phi_{wa} = -\left(\frac{4}{3}\right)^p + \frac{1}{n^2}\sum_{i,j=1}^n\prod_{k=1}^p\left[\frac{3}{2} - |x_{ik}-x_{jk}|(1-|x_{ik}-x_{jk}|)\right].}
}
\examples{
n = 20
p = 3
D = randomLHD(n, p)
uniform.crit(D)

}
\references{
Hickernell, F. (1998), “A generalized discrepancy and quadrature error bound,” Mathematics of computation, 67, 299–322.
}
