% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var1.chisq.R
\name{var1.chisq}
\alias{var1.chisq}
\title{One-Sample Chi-Square Test for Variance}
\usage{
var1.chisq(x, var0 = 1, alternative = c("two.sided", "less",
  "greater"))
}
\arguments{
\item{x}{a length-\eqn{n} data vector.}

\item{var0}{hypothesized variance \eqn{\sigma_0^2}.}

\item{alternative}{specifying the alternative hypothesis.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value \eqn{P(H_0|H_1)} under current setting.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given an univariate sample \eqn{x}, it tests
\deqn{H_0 : \sigma_x^2 \left\lbrace =,\geq,\leq \right\rbrace \sigma_0^2 \quad vs\quad H_1 : \sigma_x^2 \left\lbrace \neq,<,>\right\rbrace \sigma_0^2}.
}
\examples{
## CRAN-purpose small example
x = rnorm(10)
var1.chisq(x, alternative="g") ## Ha : var(x) >= 1
var1.chisq(x, alternative="l") ## Ha : var(x) <= 1
var1.chisq(x, alternative="t") ## Ha : var(x) =/=1

\donttest{
## empirical Type 1 error 
niter   = 1000
counter = rep(0,niter)  # record p-values
for (i in 1:niter){
  x = rnorm(50)  # sample x from N(0,1)
  
  counter[i] = ifelse(var1.chisq(x,var0=1)$p.value < 0.05, 1, 0)
}

## print the result
cat(paste("\\n* Example for 'var1.chisq'\\n\\n",
sprintf("* number of rejections   : \%d\\n",sum(counter)),
sprintf("* total number of trials : \%d\\n",niter),
sprintf("* empirical Type 1 error : \%.4f\\n", sum(counter/niter)),sep=""))
}

}
\references{
\insertRef{snedecor_statistical_1996}{SHT}
}
