% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L3_Colonies.R
\name{createMultiColony}
\alias{createMultiColony}
\title{Create MultiColony object}
\usage{
createMultiColony(x = NULL, n = NULL, location = NULL)
}
\arguments{
\item{x}{\code{\link{Pop-class}}, virgin queens or queens for the colonies
(selected at random if there are more than \code{n} in \code{Pop}, while
 all are used when \code{n} is \code{NULL})}

\item{n}{integer, number of colonies to create (if only \code{n} is
given then \code{\link{MultiColony-class}} is created with \code{n}
\code{NULL}) individual colony - this is mostly useful for programming)}

\item{location}{list, location of the colonies as \code{c(x, y)}}
}
\value{
\code{\link{MultiColony-class}}
}
\description{
Level 3 function that creates a set of colonies. Usually to
  start a simulation.
}
\details{
When both \code{x} and \code{n} are \code{NULL}, then a
  \code{\link{MultiColony-class}} with 0 colonies is created.
}
\examples{
founderGenomes <- quickHaplo(nInd = 3, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)

# Create 2 empty (NULL) colonies
apiary <- createMultiColony(n = 2)
apiary
apiary[[1]]
apiary[[2]]

# Create 2 virgin colonies
apiary <- createMultiColony(x = basePop, n = 2) # specify n
apiary <- createMultiColony(x = basePop[1:2]) # take all provided
apiary
apiary[[1]]
apiary[[2]]

# Create mated colonies by crossing
apiary <- createMultiColony(x = basePop[1:2], n = 2)
drones <- createDrones(x = basePop[3], n = 30)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 2, nDrones = 15)
apiary <- cross(apiary, drones = droneGroups)
apiary
apiary[[1]]
apiary[[2]]
}
