% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L2_Colony.R
\name{split}
\alias{split}
\title{Split colony in two MultiColony}
\usage{
split(x, p = NULL, year = NULL, simParamBee = NULL, ...)
}
\arguments{
\item{x}{\code{\link{Colony-class}} or \code{\link{MultiColony-class}}}

\item{p}{numeric, proportion of workers that will go to the split colony; if
\code{NULL} then \code{\link{SimParamBee}$splitP} is used.
If input is \code{\link{MultiColony-class}},
the input could also be a vector of the same length as the number of colonies. If
a single value is provided, the same value will be applied to all the colonies}

\item{year}{numeric, year of birth for virgin queens}

\item{simParamBee}{\code{\link{SimParamBee}}, global simulation parameters}

\item{...}{additional arguments passed to \code{p} when this argument is a
function}
}
\value{
list with two  \code{\link{Colony-class}} or \code{\link{MultiColony-class}},
the \code{split} and the \code{remnant} (see the description what each colony holds!);
both outputs have the split even slot set do \code{TRUE}
}
\description{
Level 2 function that splits a Colony or MultiColony object
  into two new colonies to
  prevent swarming (in managed situation). The remnant colony retains the
  queen and a proportion of the workers and all drones. The split colony gets
  the other part of the workers, which raise virgin queens, of which only one
  prevails. Location of the split is the same as for the remnant.
}
\examples{
founderGenomes <- quickHaplo(nInd = 10, nChr = 1, segSites = 50)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)
drones <- createDrones(basePop[1], n = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = 10)

# Create Colony and MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
(colony <- buildUp(colony, nWorkers = 100))
apiary <- createMultiColony(basePop[3:8], n = 6)
apiary <- cross(apiary, drones = droneGroups[2:7])
apiary <- buildUp(apiary, nWorkers = 100)

# Split a colony
tmp <- split(colony)
tmp$split
tmp$remnant

# Split all colonies in the apiary with p = 0.5 (50\% of workers in each split)
tmp <- split(apiary, p = 0.5)
tmp$split[[1]]
tmp$remnant[[1]]
# Split with different proportions
nWorkers(apiary)
tmp <- split(apiary, p = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6))
nWorkers(tmp$split)
nWorkers(tmp$remnant)

# Split only specific colonies in the apiary
tmp <- pullColonies(apiary, ID = c(4, 5))
# Split only the pulled colonies
(split(tmp$pulled, p = 0.5))
}
