% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{GTFScalendar}
\alias{GTFScalendar}
\title{GTFS calendar table relevant to SIRI sample}
\format{A data frame with 152 observations on the following 10 variables:
\describe{
     \item{service_id}{The service_id contains an ID that uniquely identifies a set of dates when service is available for one or more routes. }
     \item{sunday}{A binary value that indicates whether the service is valid for all Sundays.}
     \item{monday}{A binary value that indicates whether the service is valid for all Mondays}
     \item{tuesday}{A binary value that indicates whether the service is valid for all Tuesdays.}
     \item{wednesday}{A binary value that indicates whether the service is valid for all Wednesdays.}
     \item{thursday}{A binary value that indicates whether the service is valid for all Thursdays.}
     \item{friday}{A binary value that indicates whether the service is valid for all Fridays.}
     \item{saturday}{A binary value that indicates whether the service is valid for all Saturdays.}
     \item{start_date}{The start_date field contains the start date for the service. The start_date field's value should be in YYYYMMDD format.}
     \item{end_date}{The end_date field contains the end date for the service. This date is included in the service interval. The end_date field's value should be in YYYYMMDD format.}
}}
\source{
\url{https://developers.google.com/transit/gtfs/reference/#calendartxt}
}
\usage{
GTFScalendar
}
\description{
Subset of the GTFS calendar table for Israel for the SIRIsample data.
This is only a small subset of the Israeli GTFS calendar table, extracted to be used with the SIRIsample data.
it shows the calendar data for only 1 agency since the SIRIsample data only includes 1 operator in the city of Be'er Sheva.
note that GTFS is a global standard and not all operators fill all of the columns.
}
\keyword{datasets}
