% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_discr_pairwise.R
\name{prob_discr_pairwise}
\alias{prob_discr_pairwise}
\title{Calculates Probability of pairwise discrimination}
\usage{
prob_discr_pairwise(dataRaw, signal = "input", response = NULL,
  side_variables = NULL, formula_string = NULL, output_path = NULL,
  scale = TRUE, lr_maxit = 1000, MaxNWts = 5000,
  diagnostics = TRUE)
}
\arguments{
\item{dataRaw}{must be a data.frame object}

\item{signal}{is a character object with names of columns of dataRaw to be treated as channel's input.}

\item{response}{is a character vector with names of columns of dataRaw  to be treated as channel's output}

\item{side_variables}{(optional) is a character vector that indicates side variables' columns of data, if NULL no side variables are included}

\item{formula_string}{(optional) is a character object that includes a formula syntax to use in logistic regression model. 
If NULL, a standard additive model of response variables is assumed. Only for advanced users.}

\item{output_path}{is a directory where a pie chart with calculated probabilities will be saved. If NULL, the graph will not be created.}

\item{scale}{is a logical indicating if the response variables should be scaled and centered before fitting logistic regression}

\item{lr_maxit}{is a maximum number of iteration of fitting algorithm of logistic regression. Default is 1000.}

\item{MaxNWts}{is a maximum acceptable number of weights in logistic regression algorithm. Default is 5000.}

\item{diagnostics}{is a logical indicating if details of logistic regression fitting should be included in output list}
}
\value{
a list with two elements:
\itemize{
\item output$prob_matr - a \eqn{n\times n} matrix, where \eqn{n} is the number of inputs, with probabilities of correct 
discirimination between pairs of input values. 
\item output$diagnostics     - (if diagnostics=TRUE) a list correspondning to logistic regression models fitted for each 
pair of input values. Each element consists of three sub-elements: 1) nnet_model - nnet object summarising logistic regression model; 
2) prob_lr - probabilities of assignment obtained from logistic regression model; 
3) confusion_matrix - confusion matrix of classificator.
}
}
\description{
Estimates probabilities of correct discrimination (PCDs) between each pair of input/signal values using a logistic regression model.
}
\details{
In order to estimate PCDs, for a given pair of input values \eqn{x_i} and \eqn{x_j}, we propose to fit a logistic regression model
using response data corresponding to the two considered inputs, i.e. \eqn{y^l_u}, for \eqn{l\in\{i,j\}} and \eqn{u} ranging from 
1 to \eqn{n_l}. 
To ensure that both inputs have equal contribution to the calculated discriminability, equal probabilities should be assigned,
\eqn{P(X) = (P(x_i),P(x_j))=(1/2,1/2)}. Once the regression model is fitted, probability of assigning a given cellular response, 
\eqn{y},
to the correct input value is estimated as
\deqn{\max \{ \hat{P}_{lr}(x_i|Y=y;P(X)), \hat{P}_{lr}(x_j|Y=y;P(X))\}.}
Note that \eqn{P(x_j|Y=y)=1-P(x_i|Y=y)} as well as \eqn{\hat{P}_{lr}(x_j|Y=y;P(X))=1-\hat{P}_{lr}(x_i|Y=y;P(X))}
The average of the above probabilities over all observations \eqn{y^i_l} yields PCDs
\deqn{PCD_{x_i,x_j}=\frac{1}{2}\frac{1}{n_i}\sum_{l=1}^{n_i}\max\{ \hat{P}_{lr}(x_i|Y=y_i^l;P(X)),\hat{P}_{lr}(x_i^l|Y=y;P(X))\} + }
\deqn{ \frac{1}{2}  \frac{1}{n_j} \sum_{l=1}^{n_j} \max \{ \hat{P}_{lr}(x_i|Y=y_j^l;P(X)), \hat{P}_{lr}(x_j|Y=y_j^l;P(X))\}.}

Additional parameters: lr_maxit and maxNWts are the same as in definition of multinom function from nnet package. An alternative
model formula (using formula_string arguments) should be provided if  data are not suitable for description by logistic regression
(recommended only for advanced users). Preliminary scaling of  data (argument scale) should be used similarly as in other 
data-driven approaches, e.g. if response variables are comparable, scaling (scale=FALSE) can be omitted, while if they represent 
different phenomenon (varying by units and/or magnitude) scaling is recommended.
}
\section{References}{

[1] Jetka T, Nienaltowski K, Winarski T, Blonski S, Komorowski M,  
Information-theoretic analysis of multivariate single-cell signaling responses using SLEMI,
\emph{PLoS Comput Biol}, 15(7): e1007132, 2019, https://doi.org/10.1371/journal.pcbi.1007132.
}

\examples{
## Calculate probabilities of discrimination for toy dataset
temp_data=data_example1
output=prob_discr_pairwise(dataRaw=data_example1,
                   signal = "signal",
                   response = "response")
## Calculate probabilities of discrimination for nfkb dataset
 it=21 # choose from 0, 3, 6, ..., 120 for measurements at other time points
 output=prob_discr_pairwise(dataRaw=data_nfkb,
                            signal = "signal",
                           response = paste0("response_",it))

}
