% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transmissionTree.R
\name{transmissionTree}
\alias{transmissionTree}
\title{transmissionTree}
\usage{
transmissionTree(nodes, edges, nodes.color = NULL, width = NULL,
  height = NULL, elementId = NULL)
}
\arguments{
\item{nodes}{a data.frame that reprensent hosts status in time with ID, status and time in columns}

\item{edges}{a data.frame that reprensent tramsmission link between hosts (pathogens) with ID, source, target and time in columns}

\item{nodes.color}{a list of color for nodes status "status"="color"}

\item{width}{numeric width for the area in pixels.}

\item{height}{numeric hieght for the area in pixels.}

\item{elementId}{the element ID where is draw}
}
\description{
Draw a transmission tree over the time.
Time use timestamp or Date in ISO format ("%Y-%m-%dT%H:%M:%S").
}
\examples{
library(SMITIDvisu)
data(transmissiontree)
tt <- transmissionTree(tt.nodes,tt.edges, nodes.color = list("default"="black","Inf"="red"))
\donttest{
## export as standalone html file
htmlwidgets::saveWidget(tt, "transTree.html")
browseURL("transTree.html")
}

}
