% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handleNAs.R
\name{handleNAsMean}
\alias{handleNAsMean}
\title{handleNAsMean}
\usage{
handleNAsMean(
  x,
  y = NULL,
  imputeCriteriaFuns = list(is.na, is.infinite, is.nan),
  penaltyImputation = 3
)
}
\arguments{
\item{x}{The x values from which y was calculated, not used here}

\item{y}{The vector of numerics from which the NAs should be removed}

\item{imputeCriteriaFuns}{\code{list} criteria functions specified via
\code{imputeCriteriaFuns} in \code{\link{spotControl}}. Default:
\code{list(is.na, is.infinite, is.nan)}.}

\item{penaltyImputation}{penalty used for imputed values}
}
\value{
y The cleaned vector
}
\description{
Remove NAs from a vector by replacing them by the sample mean.
}
\examples{
vecWithNAs <- c(-1, 0,1,NA,3,Inf,5,NA)
control <- spotControl(dim=length(vecWithNAs))
print(vecWithNAs)
print(handleNAsMean(y=vecWithNAs,
                     imputeCriteriaFuns= control$yImputation$imputeCriteriaFuns))
}
