% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msi.dataset_methods.R
\name{binSupervised,msi.dataset-method}
\alias{binSupervised,msi.dataset-method}
\alias{binSupervised}
\title{Return a binary mask generated applying a supervised classifier
on peaks intensities using manually selected regions corresponding to off-sample
and sample-related areas.}
\usage{
\S4method{binSupervised}{msi.dataset}(
  object,
  refImage,
  mzQuery = numeric(),
  mzTolerance = Inf,
  useFullMZ = TRUE,
  method = "svm",
  verbose = TRUE
)
}
\arguments{
\item{object}{\link{msi.dataset-class} object}

\item{refImage}{\link{ms.image-class} object. Image used as reference to
manually select the ROI pixels.}

\item{mzQuery}{numeric. Values of m/z used to calculate the reference image.
2 values are interpreted as interval, multiple or single values are searched
in the m/z vector. It overrides \code{useFullMZ}.}

\item{mzTolerance}{numeric (default = Inf). Tolerance in PPM to match the
\code{mzQueryRef}. values in the m/z vector. It overrides \code{useFullMZ}.}

\item{useFullMZ}{logical (default = `TRUE``). Whether all the peaks should be
used to perform the supervised segmentation.}

\item{method}{string (default = 'svm'). Supervised classifier used to segment
the ROI.}

\item{verbose}{boolean (default = `TRUE`). Additional output.}
}
\value{
\link{ms.image-class} object representing the binary mask image.
}
\description{
Return a binary mask generated applying a supervised classifier
on peaks intensities using manually selected regions corresponding to off-sample
and sample-related areas.
}
\author{
Paolo Inglese \email{p.inglese14@imperial.ac.uk}
}
