#' Lifespan of dogs
#'
#' The average weight of dog breeds, and the average lifespan of dog breeds, 
#' using over 50 individuals for each breed.
#' 
#' @docType data
#' 
#' @keywords datasets
#'
#' @format A data frame with 73 rows and 5 columns:
#' \describe{
#'   \item{Breed}{The breed name}
#'   \item{Weight}{The average breed weight (in kg)}
#'   \item{LitterSize}{The average breed litter size}
#'   \item{BirthWeight}{The average breed birthweight (in kg)}
#'   \item{Lifespan}{The average breed lifespan (in years)}
#' }
#' 
#' @details
#' The original data list many more breeds, but these are 
#' (as best as I can determine)
#' those based on at least 50 individuals, as noted in the original article.
#' 
#' @source 
#' da Silva, Jack and Cross, Bethany (2022).
#'  Data and code for: Dog lifespans and the evolution of ageing [Dataset]. 
#'  \emph{Dryad} https://doi.org/10.5061/dryad.wwpzgmsn6
#' 
#' @references 
#' da Silva, J., & Cross, B. J. (2023). 
#' Dog life spans and the evolution of aging. 
#' \emph{The American Naturalist}, \bold{201}(6), E140--E152.
#' 
#' @usage 
#' data(DogsLife)
#' 
#' @examples
#' plot(Lifespan ~ Weight, data = DogsLife, xlab = "Breed weight (kg)", ylab = "Breed lifespan (years)")
#' 

"DogsLife"
