#' Permeability of building materials
#'
#' The permeability of building materials.
#' 
#' @docType data
#' 
#' @keywords datasets
#'
#' @format A data frame with 81 rows (each sample) and 3 columns:
#' \describe{
#'   \item{Day}{The day of the data collection; \code{1} to \code{9}}
#'   \item{Mach}{The machine; one of \code{A}, \code{B} or \code{C}}
#'   \item{Perm}{The permeability of the sample, in seconds}
#' }
#' 
#' @source 
#' Bent Joergensen (1992) Exponential dispersion models and extensions: 
#' A review. 
#' \emph{International Statistical Review}, \bold{60}(1), 5--20
#' 
#' @references 
#' A. Hald (1952).
#' \emph{Statistical theory with engineering applications}. New York: Wiley.
#'  
#' @usage 
#' data(Perm)
#' 
#' @examples
#' plot(Perm ~ factor(Mach), data = Perm, ylab = "Permeability (seconds)", xlab = "Machine")
#' 

"Perm"
