% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSL.R
\name{sslMincut}
\alias{sslMincut}
\title{Mincut}
\usage{
sslMincut(xl, yl, xu, simil.type = "correlation", k = 10)
}
\arguments{
\item{xl}{a n * p matrix or data.frame of labeled data}

\item{yl}{a n * 1 binary labels(1 or -1).}

\item{xu}{a m * p matrix or data.frame of unlabeled data.}

\item{simil.type}{character string; this parameter controls the type of similarity measurement.(see \code{\link{simil}} or \code{\link{pr_DB}}).}

\item{k}{an integer parameter controls a k-nearest neighbor graph.}
}
\value{
a m * 1 integer vector representing the predicted labels  of  unlabeled data.
}
\description{
\code{sslMincut} implements the Mincut algorithm for maxflow graph partition in the k-nearest neighbor graph.
}
\details{
\code{sslMincut} creates a k-nearest neighbor graph and finds a maxflow
from the first postive observation to the first negative one based on MPLA algorithm. This
maxflow partitions the graph into postive labels and negative ones.
}
\examples{
data(iris)
xl<-iris[c(1:20,51:70),-5]
xu<-iris[c(21:50,71:100),-5]
yl<-rep(c(1,-1),each=20)
yu<-sslMincut(xl,yl,xu)
}
\author{
Junxiang Wang
}
\references{
Blum, A., & Chawla, S. (2001). Learning from labeled and unlabeled data using
graph mincuts. Proc. 18th International Conf. on Machine Learning.
}
\seealso{
\code{\link{pr_DB}} \code{\link{simil}}
}

