% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomForest.R
\name{fit_random_forest,RandomForestSemisupervised-method}
\alias{fit_random_forest,RandomForestSemisupervised-method}
\title{Fit Random Forest}
\usage{
\S4method{fit_random_forest}{RandomForestSemisupervised}(
  object,
  X,
  y,
  mtry = 2,
  trees = 500,
  min_n = 2,
  w = 0.5,
  replace = TRUE,
  tree_max_depth = Inf,
  sampsize = if (replace) nrow(X) else ceiling(0.632 * nrow(X)),
  min_samples_leaf = if (!is.null(y) && !is.factor(y)) 5 else 1,
  allowParallel = TRUE
)
}
\arguments{
\item{object}{A RandomForestSemisupervised object}

\item{X}{A object that can be coerced as data.frame. Training instances}

\item{y}{A vector with the labels of the training instances. In this vector
the unlabeled instances are specified with the value \code{NA}.}

\item{mtry}{number of features in each decision tree}

\item{trees}{number of trees. Default is 5}

\item{min_n}{number of minimum samples in each tree}

\item{w}{weight parameter ranging from 0 to 1}

\item{replace}{replacing type in sampling}

\item{tree_max_depth}{maximum tree depth. Default is Inf}

\item{sampsize}{Size of sample. Default if (replace) nrow(x) else ceiling(.632*nrow(x))}

\item{min_samples_leaf}{the minimum number of any terminal leaf node}

\item{allowParallel}{Execute Random Forest in parallel if doParallel is loaded.
Default is TRUE}
}
\value{
list of decision trees
}
\description{
method in classRandomForestSemisupervised used to build a Decision Tree
}
