% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initial.R
\name{ssn_initial}
\alias{ssn_initial}
\alias{tailup_initial}
\alias{taildown_initial}
\alias{euclid_initial}
\alias{nugget_initial}
\title{Create a covariance parameter initial object}
\usage{
tailup_initial(tailup_type, de, range, known)

taildown_initial(taildown_type, de, range, known)

euclid_initial(euclid_type, de, range, rotate, scale, known)

nugget_initial(nugget_type, nugget, known)
}
\arguments{
\item{tailup_type}{The tailup covariance function type. Available options
include \code{"linear"}, \code{"spherical"}, \code{"exponential"},
\code{"mariah"}, \code{"epa"}, and \code{"none"}.}

\item{de}{The spatially dependent (correlated) random error variance. Commonly referred to as
a partial sill.}

\item{range}{The correlation parameter.}

\item{known}{A character vector indicating which covariance parameters are to be
assumed known. The value \code{"given"} is shorthand for assuming all
covariance parameters given to \code{*_initial()} are assumed known.}

\item{taildown_type}{The taildown covariance function type. Available options
include \code{"linear"}, \code{"spherical"}, \code{"exponential"},
\code{"mariah"}, \code{"epa"}, and \code{"none"}.}

\item{euclid_type}{The euclidean covariance function type. Available options
include \code{"spherical"}, \code{"exponential"}, \code{"gaussian"},
\code{"cosine"}, \code{"cubic"}, \code{"pentaspherical"}, \code{"wave"},
\code{"jbessel"}, \code{"gravity"}, \code{"rquad"}, \code{"magnetic"}, and
\code{"none"}.}

\item{rotate}{Anisotropy rotation parameter (from 0 to \eqn{\pi} radians) for
the euclidean portion of the covariance. A value of 0 (the default) implies no rotation.}

\item{scale}{Anisotropy scale parameter (from 0 to 1) for
the euclidean portion of the covariance. A value of 1 (the default) implies no scaling.}

\item{nugget_type}{The nugget covariance function type. Available options
include \code{"nugget"} or \code{"none"}.}

\item{nugget}{The spatially independent (not correlated) random error variance. Commonly referred to as
a nugget.}
}
\value{
A list with two elements: \code{initial} and \code{is_known}.
\code{initial} is a named numeric vector indicating the spatial covariance parameters
with specified initial and/or known values. \code{is_known} is a named
numeric vector indicating whether the spatial covariance parameters in
\code{initial} are known or not. The class of the list
matches the the relevant spatial covariance type.
}
\description{
Create a covariance parameter initial object that specifies
initial and/or known values to use while estimating specific covariance parameters
with \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.  See \code{\link[spmodel:randcov_initial]{spmodel::randcov_initial()}} for documentation regarding
random effect covariance parameter initial objects.
}
\details{
Create an initial object for use with \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.
\code{NA} values can be given for \code{ie}, \code{rotate}, and \code{scale}, which lets
these functions find initial values for parameters that are sometimes
otherwise assumed known (e.g., \code{rotate} and \code{scale} with \code{\link[=ssn_lm]{ssn_lm()}} and \code{\link[=ssn_glm]{ssn_glm()}}.
Parametric forms for each spatial covariance type are presented below.

\code{tailup_type} Details: Let \eqn{D} be a matrix of hydrologic distances,
\eqn{W} be a diagonal matrix of weights from \code{additive}, \eqn{r = D / range},
and \eqn{I} be
an identity matrix. Then parametric forms for flow-connected
elements of \eqn{R(zu)} are given below:
\itemize{
\item linear: \eqn{(1 - r) * (r <= 1) * W}
\item spherical: \eqn{(1 - 1.5r + 0.5r^3) * (r <= 1) * W}
\item exponential: \eqn{exp(-r) * W}
\item mariah: \eqn{log(90r + 1) / 90r * (D > 0) + 1 * (D = 0) * W}
\item epa: \eqn{(D - range)^2 * F * (r <= 1) * W / 16range^5}
\item gaussian: \eqn{2 exp(-r^2) * (1 - pnorm(r * 2^{1/2})) * W}
\item none: \eqn{I} * W
}

Details describing the \code{F} matrix in the \code{epa} covariance are given in Garreta et al. (2010).
Flow-unconnected elements of \eqn{R(zu)} are assumed uncorrelated.
Observations on different networks are also assumed uncorrelated.

\code{taildown_type} Details: Let \eqn{D} be a matrix of hydrologic distances,
\eqn{r = D / range},
and \eqn{I} be an identity matrix. Then parametric forms for flow-connected
elements of \eqn{R(zd)} are given below:
\itemize{
\item linear: \eqn{(1 - r) * (r <= 1)}
\item spherical: \eqn{(1 - 1.5r + 0.5r^3) * (r <= 1)}
\item exponential: \eqn{exp(-r)}
\item mariah: \eqn{log(90r + 1) / 90r * (D > 0) + 1 * (D = 0)}
\item epa: \eqn{(D - range)^2 * F1 * (r <= 1) / 16range^5}
\item gaussian: \eqn{0}
\item none: \eqn{I}
}

Now let \eqn{A} be a matrix that contains the shorter of the two distances
between two sites and the common downstream junction, \eqn{r1 = A / range},
\eqn{B} be a matrix that contains the longer of the two distances between two sites and the
common downstream junction, \eqn{r2 = B / range},  and \eqn{I} be an identity matrix.
Then parametric forms for flow-unconnected elements of \eqn{R(zd)} are given below:
\itemize{
\item linear: \eqn{(1 - r2) * (r2 <= 1)}
\item spherical: \eqn{(1 - 1.5r1 + 0.5r2) * (1 - r2)^2 * (r2 <= 1)}
\item exponential: \eqn{0}
\item mariah: \eqn{(log(90r1 + 1) - log(90r2 + 1)) / (90r1 - 90r2) * (A =/ B) + (1 / (90r1 + 1)) * (A = B)}
\item epa: \eqn{(B - range)^2 * F2 * (r2 <= 1) / 16range^5}
\item gaussian: \eqn{2 exp(-(B - A) / range) * (1 - pnorm(r * 2^{1/2})) * W}
\item none: \eqn{I}
}

Details describing the \code{F1} and \code{F2} matrices in the \code{epa}
covariance are given in Garreta et al. (2010).
Observations on different networks are assumed uncorrelated.

\code{euclid_type} Details: Let \eqn{D} be a matrix of Euclidean distances,
\eqn{r = D / range}, and \eqn{I} be an identity matrix. Then parametric
forms for elements of \eqn{R(ze)} are given below:
\itemize{
\item exponential: \eqn{exp(- r )}
\item spherical: \eqn{(1 - 1.5r + 0.5r^3) * (r <= 1)}
\item gaussian: \eqn{exp(- r^2 )}
\item cubic: \eqn{(1 - 7r^2 + 8.75r^3 - 3.5r^5 + 0.75r^7) * (r <= 1)}
\item pentaspherical: \eqn{(1 - 1.875r + 1.25r^3 - 0.375r^5) * (r <= 1)}
\item cosine: \eqn{cos(r)}
\item wave: \eqn{sin(r) * (h > 0) / r + (h = 0)}
\item jbessel: \eqn{Bj(h * range)}, Bj is Bessel-J function
\item gravity: \eqn{(1 + r^2)^{-0.5}}
\item rquad: \eqn{(1 + r^2)^{-1}}
\item magnetic: \eqn{(1 + r^2)^{-1.5}}
\item none: \eqn{I}
}

\code{nugget_type} Details: Let \eqn{I} be an identity matrix and \eqn{0}
be the zero matrix. Then parametric
forms for elements the nugget variance are given below:
\itemize{
\item nugget: \eqn{I}
\item none: \eqn{0}
}
In short, the nugget effect is modeled when \code{nugget_type} is \code{"nugget"}
and omitted when \code{nugget_type} is \code{"none"}.

Dispersion and random effect initial objects are specified via
\code{\link[spmodel:dispersion_initial]{spmodel::dispersion_initial()}} and \code{\link[spmodel:randcov_initial]{spmodel::randcov_initial()}}, respectively.
}
\examples{
tailup_initial("exponential", de = 1, range = 20, known = "range")
tailup_initial("exponential", de = 1, range = 20, known = "given")
euclid_initial("spherical", de = 2, range = 4, scale = 0.8, known = c("range", "scale"))
dispersion_initial("nbinomial", dispersion = 5)

}
\references{
Peterson, E.E. and Ver Hoef, J.M. (2010) A mixed-model moving-average approach
to geostatistical modeling in stream networks. \emph{Ecology} \bold{91(3)},
644--651.

Ver Hoef, J.M. and Peterson, E.E. (2010) A moving average approach for spatial
statistical models of stream networks (with discussion).
\emph{Journal of the American Statistical Association} \bold{105}, 6--18.
DOI: 10.1198/jasa.2009.ap08248.  Rejoinder pgs. 22--24.
}
