% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simhyper.R
\name{simhyper}
\alias{simhyper}
\title{Simulate hyperpriors from an GMRF}
\usage{
simhyper(
  R = 2,
  nsamp = 1e+05,
  nsamp.check = 5000,
  Amat,
  nperiod = 6,
  only.iid = TRUE
)
}
\arguments{
\item{R}{Desired prior odds ratio. Default to 2, i.e., a 95\% prior interval for the residual odds ratios lies in the interval (R, 1/R).}

\item{nsamp}{Sample to simulate for scaling factor}

\item{nsamp.check}{Sample to simulate for checking range}

\item{Amat}{Adjacency matrix of the areas in the data.}

\item{nperiod}{numerical value of how many time periods in the data}

\item{only.iid}{Indicator for whether or not only IID hyperpriors are simulated}
}
\description{
Simulate hyperpriors from an GMRF
}
\examples{
\dontrun{
data(DemoMap)
mat <- DemoMap$Amat
priors <- simhyper(R = 2, nsamp = 1e+05, nsamp.check = 5000, Amat = mat)
}
}
\references{
Wakefield, J. Multi-level modelling, the ecologic fallacy, and hybrid study designs. \emph{International Journal of Epidemiology}, 2009, vol. 38 (pg. 330-336).
}
\author{
Zehang Richard Li, Laina Mercer
}
