% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nesting.R
\name{nesting}
\alias{nesting}
\title{Relative scale and nesting coefficients}
\usage{
nesting(poly_from = NULL, poly_to = NULL, metrix = "all", tol_ = 0.001)
}
\arguments{
\item{poly_from}{Source polygon layer. \code{sf} object (polygon or multipolygon).}

\item{poly_to}{Destination polygon layer. Must have identical CRS to \code{poly_from}. \code{sf} object (polygon or multipolygon).}

\item{metrix}{Requested scaling and nesting metrics. See "details". Default is "all". Character string or vector of character strings.}

\item{tol_}{Minimum area of polygon intersection, in square meters. Default is 0.001. Numeric.}
}
\value{
Named list, with numeric values for each requested metric in \code{metrix}.
}
\description{
Function to calculate relative scale and nesting metrics for changes of support from a source polygon layer to an overlapping (but spatially misaligned) destination polygon layer.
}
\details{
Currently supported metrics (\code{metrix}) include:
\itemize{
 \item{Relative scale ("rs"). }{Measures whether a change-of-support (CoS) task is one of aggregation or disaggregation, by calculating the share of source units that are smaller than destination units. Its range is from 0 to 1, where values of 1 indicate pure aggregation (all source units are smaller than destination units) and values of 0 indicate no aggregation (all source units are at least as large as destination units). Values between 0 and 1 indicate a hybrid (i.e. some source units are smaller, others are larger than target units).}
 \item{Relative nesting ("rn"). }{Measures how closely source and destination boundaries align, by calculating the share of source units that cannot be split across multiple destination units. Its range is from 0 to 1, where values of 0 indicate no nesting (every source unit can be split across multiple destination units) and values of 1 indicate full nesting (no source unit can be split across multiple destination units).}
 \item{Relative scale, symmetric ("rs_sym"). }{Alternative measure of "rs", which ranges from -1 to 1. It calculates a difference between two proportions: the share of source units that is smaller than destination units (i.e. "rs" from standpoint of source units), and the share that is larger (i.e. "rs" from standpoint of destination units). Values of -1 indicate pure disaggregation (all source units are larger than destination units), 1 indicates pure aggregation (all source units are smaller than destination units). Values of 0 indicate that all source units are the same size as target units.}
 \item{Relative nesting, symmetric ("rn_sym"). }{Alternative measure of "rn", which ranges from -1 to 1. It calculates a difference between two components: the nesting of source units within destination units (i.e. "rn" from standpoint of source units), and the nesting of destination units within source units (i.e. "rn" from standpoint of destination units. Values of 1 indicate that source units are perfectly nested within destination units; -1 indicates that destination units are perfectly nested within source units.}
 \item{Relative scale, alternative ("rs_alt"). }{Alternative measure of "rs", rescaled as a proportion of destination unit area. This measure can take any value on the real line, with positive values indicating aggregation and negative values indicating disaggregation.}
 \item{Relative nesting, alternative ("rn_alt"). }{Alternative measure of "rn", which places more weight on areas of maximum overlap. The main difference between this measure and "rn" is its use of  the maximum intersection area for each source polygon instead of averaging over the quadratic term. Two sets of polygons are considered nested if one set is completely contained within another, with as few splits as possible. If none or only a sliver of a source polygon area falls outside a single destination polygon, those polygons are "more nested" than a case where 50% of a source polygon falls in destination polygon A and 50% falls into another polygon B.}
 \item{Proportion intact ("pi_intact"}). }{A nesting metric that requires no area calculations at all. This measure ranges from 0 to 1, where 1 indicates full nesting (i.e. every source unit is intact/no splits), and 0 indicates no nesting (i.e. no source unit is intact/all are split).}
 \item{Relative overlap ("ro"). }{Assesses extent of spatial overlap between source and destination polygons. This measure is scaled between -1 and 1. Values of 0 indicate perfect overlap (there is no part of source units that fall outside of destination units, and vice versa). Values between 0 and 1 indicate a "source underlap" (some parts of source polygons fall outside of destination polygons; more precisely, a larger part of source polygon area falls outside destination polygons than the other way around). Values between -1 and 0 indicate a "destination underlap" (some parts of destination polygons fall outside of source polygons; a larger part of destination polygon area falls outside source polygons than the other way around). Values of -1 and 1 indicate no overlap (all source units fall outside destination units, and vice versa). This is a theoretical limit only; the function returns an error if there is no overlap.}
 \item{Gibbs-Martin index of diversification ("gmi"). }{Inverse of "rn", where values of 1 indicate that every source unit is evenly split across multiple destination units, and 0 indicates that no source unit is split across any destination units.}
}
It is possible to pass multiple arguments to \code{metrix} (e.g. \code{metrix=c("rn","rs")}). The default (\code{metrix="all"}) returns all of the above metrics.

The function automatically reprojects source and destination geometries to Lambert Equal Area prior to calculation, with map units in meters.

Values of \code{tol_} can be adjusted to increase or decrease the sensitivity of these metrics to small border misalignments. The default value discards polygon intersections smaller than 0.001 square meters in area.
}
\examples{
# Calculate all scale and nesting metrics for two sets of polygons
\dontrun{
data(clea_deu2009)
data(hex_05_deu)
nest_1 <- nesting(
              poly_from = clea_deu2009,
              poly_to = hex_05_deu
              )
nest_1
}

# Calculate just Relative Nesting, in the opposite direction
\dontrun{
nest_2 <- nesting(
              poly_from = hex_05_deu,
              poly_to = clea_deu2009,
              metrix = "rn"
              )
nest_2
}
}
