% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/swmpr_misc.R
\name{calckl}
\alias{calckl}
\title{Calculate oxygen mass transfer coefficient}
\usage{
calckl(temp, sal, atemp, wspd, bp, height = 10)
}
\arguments{
\item{temp}{numeric for water temperature (C)}

\item{sal}{numeric for salinity (ppt)}

\item{atemp}{numeric for air temperature (C)}

\item{wspd}{numeric for wind speed (m/s)}

\item{bp}{numeric for barometric pressure (mb)}

\item{height}{numeric for height of anemometer (meters)}
}
\description{
Calculate oxygen mass transfer coefficient using equations in Thiebault et al. 2008.  Output is used to estimate the volumetric reaeration coefficient for ecosystem metabolism.
}
\details{
This function is used within the \code{\link{ecometab}} function and should not be used explicitly.
}
\references{
Ro KS, Hunt PG. 2006. A new unified equation for wind-driven surficial oxygen transfer into stationary water bodies. Transactions of the American Society of Agricultural and Biological Engineers. 49(5):1615-1622.

Thebault J, Schraga TS, Cloern JE, Dunlavey EG. 2008. Primary production and carrying capacity of former salt ponds after reconnection to San Francisco Bay. Wetlands. 28(3):841-851.
}
\seealso{
\code{\link{ecometab}}
}

