% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swmpr_analyze.R
\name{plot_metab}
\alias{plot_metab}
\alias{plot_metab.swmpr}
\title{Plot ecosystem metabolism for a swmpr object}
\usage{
plot_metab(swmpr_in, ...)

\method{plot_metab}{swmpr}(swmpr_in, by = "months", alpha = 0.05,
  width = 10, pretty = TRUE, ...)
}
\arguments{
\item{swmpr_in}{input swmpr object}

\item{...}{arguments passed to or from other methods}

\item{by}{chr string describing aggregation period, passed to \code{\link{aggremetab}}. See details for accepted values.}

\item{alpha}{numeric indicating alpha level for confidence intervals in aggregated data. Use \code{NULL} to remove from the plot.}

\item{width}{numeric indicating width of top and bottom segments on error bars}

\item{pretty}{logical indicating use of predefined plot aesthetics}
}
\value{
A \code{\link[ggplot2]{ggplot}} object which can be further modified.
}
\description{
Plot gross production, total respiration, and net ecosystem metabolism for a swmpr object.
}
\details{
A plot will only be returned if the \code{metabolism} attribute for the \code{\link{swmpr}} object is not \code{NULL}.  Daily metabolism estimates are also aggregated into weekly averages.  Accepted aggregation periods are \code{'years'}, \code{'quarters'}, \code{'months'}, \code{'weeks'}, and \code{'days'} (if no aggregation is preferred).

By default, \code{pretty = TRUE} will return a \code{\link[ggplot2]{ggplot}} object with predefined aesthetics.  Setting \code{pretty = FALSE} will return the plot with minimal modifications to the \code{\link[ggplot2]{ggplot}} object.  Use the latter approach for easier customization of the plot.
}
\examples{
\dontrun{
## import water quality and weather data
data(apadbwq)
data(apaebmet)

## qaqc, combine
wq <- qaqc(apadbwq)
met <- qaqc(apaebmet)
dat <- comb(wq, met)

## estimate metabolism
res <- ecometab(dat)

## plot
plot_metab(res)

## change alpha, aggregation period, widths
plot_metab(res, by = 'quarters', alpha = 0.1, widths = 0)

## plot daily raw, no aesthetics
plot_metab(res, by = 'days', pretty = FALSE)

## note the difference if aggregating with a moving window average
plot_metab(res, by = 30)
}
}
\seealso{
\code{\link{aggremetab}}, \code{\link{ecometab}}
}
\concept{
analyze

analyze
}
