% From SamplerCompare, (c) 2010 Madeleine Thompson
% $Id: compare.samplers.Rd 1607 2010-09-11 15:45:13Z mthompson $

\name{compare.samplers}

\alias{compare.samplers}

\title{Compare MCMC samplers on distributions}

\description{Simulate a set of distributions with a set of samplers
and tuning parameters}

\usage{compare.samplers(sample.size, dists, samplers, tuning=1,
                 trace=TRUE, seed=17, include.ics=FALSE)}

\arguments{
  \item{sample.size}{An integer specifying how long a chain to simulate.}

  \item{dists}{A list of \code{dist} objects (often generated by
    \code{\link{make.dist}}) specifying the probability distributions
    to simulate.}

  \item{samplers}{A list of sampler functions.  See
    the section \dQuote{Sampler calling convention}.}

  \item{tuning}{A numeric vector of tuning parameters}

  \item{trace}{A logical indicating whether a message should be
    printed when a chain completes (useful for large simulations).}

  \item{seed}{If not null, the random seed is set to this with
    \code{\link{set.seed}} before each chain and restored afterwards.
    This makes each chain individually replicable, useful when
    debugging.}

  \item{include.ics}{In addition to fitting an autoregressive model
    to estimate the ACT, also compute it with the initial convex
    sequence; see \code{\link{ics.act}}.  This requires the \pkg{mcmc}
    package.}
}

\details{
  \code{compare.samplers} runs a single Markov chain simulation of
  length \code{sampler.size} size for each combination of the elements
  of \code{dists}, \code{samplers}, and \code{tuning}.  It returns
  a data frame with one row per simulation so that performance of
  the methods can be compared on the various distributions.  The
  simplest way to visualize the results is with the
  \code{\link{comparison.plot}} function.

  For an example of the use of this method, see the \dQuote{Introduction
  to SamplerCompare} vignette.  For discussion of the ideas behind
  it, see Thompson (2010).
}

\value{
  A data frame with columns \code{sampler}, \code{dist},
  \code{sampler.expr}, \code{dist.expr}, \code{ndim}, \code{tuning},
  \code{act}, \code{act.se}, \code{act.025}, \code{act.975},
  \code{evals}, \code{grads}, \code{aborted}, \code{cpu}, \code{err},
  and possibly \code{act.ics}.  Each row represents a single
  simulation.

  \itemize{
    \item \code{sampler} and \code{dist} are the names of the sampler
      and distribution taken from the lists passed to
      \code{compare.samplers}.
    \item \code{sampler.expr} and \code{dist.expr} are
      \code{\link{plotmath}} versions of \code{sampler} and \code{dist}.
      If not specified by the distribution object and sampler function,
      they are constructed from \code{dist} and \code{sampler}.
    \item \code{ndim} is the dimension of the state space of the
      target distribution.
    \item \code{tuning} is the tuning parameter for the chain.
    \item \code{act} and \code{act.se} are the estimated autocorrelation
      time and its standard error, taken over all parameters of the
      simulation; see \code{\link{ar.act}}.
    \item \code{act.025} and \code{act.975} bound a nominal 95\%
      confidence interval for \code{act}.  Since the interval is
      asymmetric, the standard error is not sufficient to generate these.
    \item \code{evals} and \code{grads} are the mean log-density
      and gradient evaluations per observation.
    \item \code{cpu} is the number of processor seconds used per
      observation.
    \item \code{aborted} is a logical indicating whether the
      simulation returned fewer rows than requested.
    \item \code{err} is the two-norm of the difference
      between the estimated mean and the true mean.  Set to \code{NA}
      if the distribution does not specify a true mean.
    \item \code{act.ics} is the autocorrelation time estimated with the
      initial convex sequence estimator.  It is only present if
      \code{include.ics} is set.
  }
}

\section{Sampler calling convention}{
  Sampler functions passed to \code{compare.samplers} should be of
  the form:
  \preformatted{sampler(target.dist, x0, sample.size, tuning)}
  \code{target.dist} is a \code{dist} object representing
  the distribution to sample from; see \code{\link{make.dist}} for
  more information on these.  \code{x0} is the initial state of the
  chain; it must be a numeric vector of length \code{target.dist$ndim}.
  \code{sample.size} is the desired length of the chain, passed
  down from \code{compare.samplers}.  \code{tuning} is a scalar
  tuning parameter from the vector passed to \code{compare.samplers}.

  Sampler functions should return a list with elements \code{X},
  \code{evals}, and (optionally) \code{grads}.  \code{X} should be
  a matrix with \code{target.dist$ndim} columns and \code{sample.size}
  rows.  If for some reason it is necessary to abort the chain,
  returning fewer rows is acceptable.  \code{evals} and \code{grads}
  indicate the number of calls to \code{target.dist$log.density}
  and \code{target.dist$grad.log.density} respectively.

  Sampler functions must have a \code{name} attribute with a human-readable
  name for the MCMC method.  If desired, they may also have a
  \code{name.expression} attribute containing a more nicely-formatted
  version of the name in \code{\link{plotmath}} format.

  See the vignette \dQuote{Introduction to SamplerCompare} for an
  example of a function that implements this interface.
}

\references{
  Thompson, M. B. (2010).  Graphical comparison of MCMC performance
    (forthcoming).
}

\seealso{
  \code{\link{make.dist}},
  \code{\link{comparison.plot}},
  \code{\link{ar.act}},
  \code{\link{ics.act}},
  \dQuote{Introduction to SamplerCompare} (vignette)
}
