% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crude_pr.R
\name{crude_pr}
\alias{crude_pr}
\title{Crude Prevalence Rate.
Calculate a group's Crude Prevalence Rate (Rate Per 1,000).
This is created to work with datasets that have 1 row per individual and Columns as variables.
This function utilises the Tidyverse framework of Non-Standard Evaluation.
As such arguments are passed to the function without quotation.}
\usage{
crude_pr(dataset_base_pop, dataset_condition_pop, demographic)
}
\arguments{
\item{dataset_base_pop}{A dataframe containing 1 row per patient of an entire population}

\item{dataset_condition_pop}{A dataframe containing 1 row per patient of the population with a given condition}

\item{demographic}{This the grouping variable over which the rates with be calculated}
}
\value{
a ggplot object
}
\description{
Crude Prevalence Rate.
Calculate a group's Crude Prevalence Rate (Rate Per 1,000).
This is created to work with datasets that have 1 row per individual and Columns as variables.
This function utilises the Tidyverse framework of Non-Standard Evaluation.
As such arguments are passed to the function without quotation.
}
\examples{
library(SangerTools)
library(dplyr)
health_data <- SangerTools::PopHealthData
glimpse(health_data)
# Generate crude prevalene rate stats
crude_prevalence <- SangerTools::crude_pr(health_data, health_data \%>\%
dplyr::filter(Diabetes==1), Locality)
print(crude_prevalence)
}
